"""
Created in 2025

@author: Konstantina Kolovou Kouri
"""

import matplotlib.pyplot as plt
import numpy as np
from pypalettes import load_cmap
cmap = load_cmap(["BluGrn", "Althoff", "Acadia"])


data = np.loadtxt(
        "C:/VNS_manuscript/data/400PP_OC.CSV",
        delimiter=",",
        skiprows=1,
    ).T
t, ch1, ch2, ch3 = data
t *= 1e06

fig, ax = plt.subplots(figsize=(10, 6))
ax.plot(t, ch1, label='TX voltage V$_\mathrm{TX,pp}$', color='#FED789FF') 
ax.plot(t, ch2, label='RX voltage V$_\mathrm{RX,pp}$', color='#72874EFF') 
ax.plot(t, ch3, label='rectified voltage', color='#023743FF') 

ax.set_xlabel('Time (µs)', fontsize=20)
ax.set_ylabel('Voltage (V)', fontsize=20)
plt.xlim([0, 20])
ax.legend(fontsize=18, loc=4)
ax.tick_params(axis='both', which='major', labelsize=14)
ax.grid()

#plt.savefig("Vtx_Vrx_Vrect.pdf", bbox_inches="tight")


# values based on measurements from 26.02.2025
v_rx = (2.3, 3.4, 4.4, 4.99, 7.4, 9.6, 12, 14.1, 14.7)
v_rect = (0.395, 0.5, 0.64, 0.65, 2.16, 3.17, 4.28, 5.1, 5.37)

v_rx_oc = (2.6, 5.4, 8.1, 10.8, 13.4, 16.1, 18.6, 21.1, 23.8, 26.3)
v_rect_oc = (2.2, 4.7, 7.3, 9.8, 12.4, 14.2, 16.7, 19.3, 21.7, 24.2)

v_rx_1k = (2.6, 4.8, 7.1, 9.4, 11.8, 14, 16.3, 18.5, 20.1, 22.2)
v_rect_1k = (0.656, 1.6, 2.6, 3.6, 4.6, 5.6, 6.7, 7.4, 8.3, 9.3)

v_rx_3k = (2.5, 5.2, 8, 10.6, 13.3, 15.6, 18.2, 20.7, 23.4, 25.9)
v_rect_3k = (1.1, 2.6, 4.1, 5.6, 7.1, 8.2, 9.7, 11.1, 12.5, 13.9)

v_rx_10k = (2.5, 4.9, 7.2, 9.6, 12.1, 14.4, 16.6, 19, 21.3, 22.5)
v_rect_10k = (1.5, 3.47, 5.5, 7.5, 9.4, 11.4, 13.3, 15.3, 17.1, 18.3)

fig, ax = plt.subplots(figsize=(10, 6))
 
ax.plot(v_rx_oc, v_rect_oc, marker = 's', label='open-circuit', color='#D9636CFF')
ax.plot(v_rx_10k, v_rect_10k, marker = 'x', label='10kΩ', color='#251714FF')
ax.plot(v_rx_3k, v_rect_3k, marker = '*', label='3kΩ', color='#691238FF')
ax.plot(v_rx_1k, v_rect_1k, marker = '+', label='1kΩ', color='#A91E45FF')
ax.plot(v_rx, v_rect, marker = 'o', label='PCB', color='#FF9898FF')

ax.set_xlabel('RX Voltage (V$_\mathrm{pp}$)', fontsize=20)
ax.set_ylabel('Rectified DC Voltage (V)', fontsize=20)
ax.set_ylim(0, 25)
ax.legend(fontsize=18, loc=2)
ax.tick_params(axis='both', which='major', labelsize=14)
ax.grid()

#plt.savefig("Vrx_vs_Vrect.pdf", bbox_inches="tight")


plt.show()