"""
Created in 2025

@author: Konstantina Kolovou Kouri
"""

import pandas as pd
import matplotlib.pyplot as plt
import glob

from itertools import cycle

def Vout_varry_Vrect(file_path):

    csv_files = glob.glob(file_path + '/*.csv')

    colors = cycle(['#0072B2', '#56B4E9', '#E69F00', '#009E73'])
    labels =cycle(['V$_\mathrm{rect}$ = 3.5V', 'V$_\mathrm{rect}$ = 4V','V$_\mathrm{rect}$ = 4.5V', 'V$_\mathrm{rect}$ = 5V'])

    fig, ax = plt.subplots(figsize=(10, 6))

    for csv_file in csv_files:

        # Start of plot definition
        df = pd.read_csv(csv_file, skiprows=20)

        color = next(colors)
        label = next(labels)

        ax.plot((df['TIME']*10**6)+1000, df['CH3'], label=label, color=color)


    ax.set_xlabel('Time (µs)', fontsize=20)
    ax.set_ylabel('Amplitude (V)', fontsize=20)
    ax.legend(fontsize=18, loc=4)

    # ylim can be changed based on the available data and preferences
    #plt.ylim(1.6, 2.3)
    plt.xlim(0,2000)

    ax.tick_params(axis='both', which='major', labelsize=14)

    # Ensure the main plot
    ax.grid(True) 

    #plt.savefig("Vout_varry_Vrect.pdf", bbox_inches="tight")
    

Vout_varry_Vrect('C:\\VNS_manuscript\\data\\Vout_varry_Vrect')

plt.show()