"""
Created in 2025

@author: Konstantina Kolovou Kouri
"""

import pandas as pd
import matplotlib.pyplot as plt
import glob

from mpl_toolkits.axes_grid1.inset_locator import inset_axes, mark_inset
from itertools import cycle
from pypalettes import load_cmap

cmap = load_cmap(["Alexandrite"])


def plot_optimization_Kp(file_path):

    csv_files = glob.glob(file_path + '/*.csv')

    colors = cycle(['#6EC5ABFF', '#CB6BCEFF', '#468892FF', '#74F3D3FF', '#751C6DFF', '#FDC067FF', '#240E31FF', '#AC9ECEFF'])
    labels = cycle(['K$_\mathrm{p}$ = 0', 'K$_\mathrm{p}$ = 0.0001', 'K$_\mathrm{p}$ = 0.004','K$_\mathrm{p}$ = 0.05', 'K$_\mathrm{p}$ = 0.8', 'K$_\mathrm{p}$ = 1.2', 'K$_\mathrm{p}$ = 3.0', 'K$_\mathrm{p}$ = 5.0'])
    delays = cycle([8.12, 8.24, 8.06, 8.15, 8.05, 8.13, 8.09, 8.58]) 
    
    fig, ax = plt.subplots(figsize=(10, 6))

    # Create an inset plot that zooms in on the time range
    ax_inset = inset_axes(ax, width="40%", height="30%", loc="lower center",
                          bbox_to_anchor=(0.1, 0.25, 0.7, 0.7), bbox_transform=ax.figure.transFigure)

    for csv_file in csv_files:

        df = pd.read_csv(csv_file, skiprows=20)

        # Calculate moving averages with a window size of 5
        #df['CH1_MA'] = df['CH1'].rolling(window=10).mean()
        df['CH2_MA'] = df['CH2'].rolling(window=50).mean()
        df['CH3_MA'] = df['CH3'].rolling(window=50).mean()
        #df['CH4_MA'] = df['CH4'].rolling(window=10).mean()

        color = next(colors)
        label = next(labels)
        delay = next(delays)

        #plt.plot(df['TIME'], df['CH1_MA'], label=label, color=color)
        #plt.plot(df['TIME'], df['CH2_MA'], label=label, color=color)
        zorder = 10
        if (csv_file == "C:\\VNS_manuscript\\data\\Kp_optimisation\\8_Kp_5_0.csv"):
            zorder = 0
        ax.plot(df['TIME'] + delay, df['CH3_MA'], label=label, color=color, zorder=zorder)
        #plt.plot(df['TIME'] + delay, df['CH4_MA'], label=label, color=color) 

        # Plot the same data on the inset axes but zoomed in
        ax_inset.plot(df['TIME'] + delay, df['CH3_MA'], color=color)

        print(csv_file)

    #plt.set_title(title, fontsize=18, pad=24)
    ax.set_xlabel('Time (s)', fontsize=20)
    ax.set_ylabel('Amplitude (V)', fontsize=20)
    ax.legend(fontsize=18, loc=4)

    ax.tick_params(axis='both', which='major', labelsize=14)

    # Set the x and y limits to zoom in on the desired range
    ax_inset.set_xlim(0, 1)
    ax_inset.set_ylim(df[['CH3_MA']].loc[(df['TIME'] >= 0) & (df['TIME'] <= 3)].min().min() - 0.03,
                      df[['CH3_MA']].loc[(df['TIME'] >= 0) & (df['TIME'] <= 3)].max().max() + 0.04)

    ax_inset.tick_params(axis='both', which='major', labelsize=10)

    # Grid inset
    ax_inset.grid(True)
    # Grid main plot
    ax.grid(True)

    # x/ylim can be changed based on the available data and preferences
    #plt.ylim(1.6, 2.2)
    ax.set_xlim(-1,18)

    # Connect the rectangle to the inset
    mark_inset(ax, ax_inset, loc1=2, loc2=1, fc="none", ec="0.3")

    #plt.savefig("Kp_optimisation.pdf", bbox_inches="tight")
    plt.show()


def plot_optimization_Ki(file_path):

    csv_files = glob.glob(file_path + '/*.csv')

    colors = cycle(['#6EC5ABFF', '#CB6BCEFF', '#468892FF', '#74F3D3FF', '#751C6DFF', '#FDC067FF', '#240E31FF', '#AC9ECEFF'])
    labels = cycle(['K$_\mathrm{i}$ = 0.0001', 'K$_\mathrm{i}$ = 0.004','K$_\mathrm{i}$ = 0.01', 'K$_\mathrm{i}$ = 0.05', 'K$_\mathrm{i}$ = 0.08', 'K$_\mathrm{i}$ = 0.3', 'K$_\mathrm{i}$ = 0.7', 'K$_\mathrm{i}$ = 1.2'])
    delays = cycle([8.04, 7.94, 8.06, 8.03, 8.02, 7.96, 8.07, 8.16]) 

    fig, ax = plt.subplots(figsize=(10, 6))

    # Create an inset plot that zooms in on the time range 9.4s to 10.05s
    ax_inset = inset_axes(ax, width="40%", height="30%", loc="lower center",
                          bbox_to_anchor=(0.1, 0.25, 0.7, 0.7), bbox_transform=ax.figure.transFigure)

    for csv_file in csv_files:

        df = pd.read_csv(csv_file, skiprows=20)

        # Calculate moving averages with a window size of 5
        #df['CH1_MA'] = df['CH1'].rolling(window=10).mean()
        df['CH2_MA'] = df['CH2'].rolling(window=50).mean()
        df['CH3_MA'] = df['CH3'].rolling(window=50).mean()
        #df['CH4_MA'] = df['CH4'].rolling(window=10).mean()

        color = next(colors)
        label = next(labels)
        delay = next(delays)

        #plt.plot(df['TIME'], df['CH1_MA'], label=label, color=color)
        #plt.plot(df['TIME'], df['CH2_MA'], label=label, color=color)
        zorder = 10
        if (csv_file == "C:\\VNS_manuscript\\data\\Ki_optimisation\\09_Ki_1_2.csv"):
            zorder = 0
        ax.plot(df['TIME'] + delay, df['CH3_MA'], label=label, color=color, zorder=zorder)
        #ax.plot(df['TIME'] + delay, df['CH4_MA'], label=label, color=color)

        # Plot the same data on the inset axes but zoomed in
        ax_inset.plot(df['TIME'] + delay, df['CH3_MA'], color=color)

        #print(csv_file)

    ax.set_xlabel('Time (s)', fontsize=20)
    ax.set_ylabel('Amplitude (V)', fontsize=20)
    ax.legend(fontsize=18, loc=4)

    ax.tick_params(axis='both', which='major', labelsize=14)

    # Set the x and y limits to zoom in on the desired range
    ax_inset.set_xlim(0, 1)
    ax_inset.set_ylim(df[['CH3_MA']].loc[(df['TIME'] >= 0) & (df['TIME'] <= 3)].min().min() - 0.1, 
                      df[['CH3_MA']].loc[(df['TIME'] >= 0) & (df['TIME'] <= 3)].max().max() + 0.1) 

    ax_inset.tick_params(axis='both', which='major', labelsize=10)

    # Grid inset
    ax_inset.grid(True)
    # Grid main plot
    ax.grid(True)

    # x/ylim can be changed based on the available data and preferences
    #plt.ylim(1.6, 2.2)
    ax.set_xlim(-1,18)

    # Connect the rectangle to the inset
    mark_inset(ax, ax_inset, loc1=2, loc2=1, fc="none", ec="0.3")

    #plt.savefig("Ki_optimisation.pdf", bbox_inches="tight")
    plt.show()


def plot_optimization_Kd(file_path):

    csv_files = glob.glob(file_path + '/*.csv')

    colors = cycle(['#6EC5ABFF', '#CB6BCEFF', '#468892FF', '#74F3D3FF', '#751C6DFF', '#FDC067FF'])
    labels = cycle(['K$_\mathrm{d}$ = 0.001', 'K$_\mathrm{d}$ = 0.05', 'K$_\mathrm{d}$ = 0.3', 'K$_\mathrm{d}$ = 1.5', 'K$_\mathrm{d}$ = 5.0', 'K$_\mathrm{d}$ = 10.0'])
    delays = cycle([8.22, 8.22, 8.05, 8.18, 8.17, 8.08])

    fig, ax = plt.subplots(figsize=(10, 6))

    # Create an inset plot that zooms in on the time range 9.4s to 10.05s
    ax_inset = inset_axes(ax, width="40%", height="30%", loc="lower center",
                          bbox_to_anchor=(0.1, 0.25, 0.7, 0.7), bbox_transform=ax.figure.transFigure)
    
    for csv_file in csv_files:

        df = pd.read_csv(csv_file, skiprows=20)

        # Calculate moving averages with a window size of 5
        #df['CH1_MA'] = df['CH1'].rolling(window=10).mean()
        df['CH2_MA'] = df['CH2'].rolling(window=50).mean()
        df['CH3_MA'] = df['CH3'].rolling(window=50).mean()
        #df['CH4_MA'] = df['CH4'].rolling(window=10).mean()

        color = next(colors)
        label = next(labels)
        delay = next(delays)

        #plt.plot(df['TIME'], df['CH1_MA'], label=label, color=color, linestyle='solid')
        #plt.plot(df['TIME'], df['CH2_MA'], label=label, color=color, linestyle='dashed')
        zorder = 10
        if (csv_file == "C:\\VNS_manuscript\\data\\Kd_optimisation\\6_Kd_10_0.csv"):
            zorder = 0
        ax.plot(df['TIME'] + delay, df['CH3_MA'], label=label, color=color, zorder=zorder)
        #plt.plot(df['TIME']+delay, df['CH4_MA'], label=label, color=color)

        # Plot the same data on the inset axes but zoomed in
        ax_inset.plot(df['TIME'] + delay, df['CH3_MA'], color=color)

        #print(csv_file)

    #plt.set_title(title, fontsize=18, pad=24)
    ax.set_xlabel('Time (s)', fontsize=20)
    ax.set_ylabel('Amplitude (V)', fontsize=20)
    ax.legend(fontsize=18, loc=4)

    ax.tick_params(axis='both', which='major', labelsize=14)

    # Set the x and y limits to zoom in on the desired range
    ax_inset.set_xlim(0, 1)
    ax_inset.set_ylim(df[['CH3_MA']].loc[(df['TIME'] >= 0) & (df['TIME'] <= 3)].min().min() - 0.1, 
                      df[['CH3_MA']].loc[(df['TIME'] >= 0) & (df['TIME'] <= 3)].max().max() + 0.1) 

    ax_inset.tick_params(axis='both', which='major', labelsize=10)

    # Grid inset
    ax_inset.grid(True)
    # Grid main plot
    ax.grid(True)

    # x/ylim can be changed based on the available data and preferences
    #plt.ylim(1.6, 2.2)
    ax.set_xlim(-1,18)

    # Connect the rectangle to the inset
    mark_inset(ax, ax_inset, loc1=2, loc2=1, fc="none", ec="0.3")

    #plt.savefig("Kd_optimisation.pdf", bbox_inches="tight")
    plt.show()

#plot_optimization_Kp('C:\\VNS_manuscript\\data\\Kp_optimisation')
#plot_optimization_Ki('C:\\VNS_manuscript\\data\\Ki_optimisation')
plot_optimization_Kd('C:\\VNS_manuscript\\data\\Kd_optimisation')