"""
Created in 2025

@author: Konstantina Kolovou Kouri
"""

import matplotlib.pyplot as plt
import pandas as pd

from itertools import cycle

def plot_modulab_eis_data(file_path):

    # Function to read a file and extract impedance data
    def read_impedance_data(file_path):
        df = pd.read_csv(file_path, skiprows=3)  # Skip the first 3 rows
        df.columns = df.columns.str.strip()  # Remove any leading/trailing whitespace in column names
        df = df.dropna(subset=["Z' (Ohm)", "Z'' (Ohm)"])  # Discard rows that don't contain Z data
        df["Z' (Ohm)"] = pd.to_numeric(df["Z' (Ohm)"], errors='coerce') # Coerce - If value cannot be converted to a number, replaced with NaN
        df["Z'' (Ohm)"] = pd.to_numeric(df["Z'' (Ohm)"], errors='coerce')
        df = df.dropna(subset=["Z' (Ohm)", "Z'' (Ohm)"])

        frequency = pd.to_numeric(df["Frequency (Hz)"], errors='coerce')
        impedance = pd.to_numeric(df["| Z | (Ohm)"], errors='coerce')
        phases = pd.to_numeric(df["Phase (Deg)"], errors='coerce')
        real_imp = pd.to_numeric(df["Z' (Ohm)"], errors='coerce')
        imag_imp = pd.to_numeric(df["Z'' (Ohm)"], errors='coerce')

        return frequency, impedance, phases, real_imp, imag_imp

    frequency, impedance, phases, real_imp, imag_imp = read_impedance_data(file_path)

    # Create subplots: one for magnitude and one for phase
    #fig, (ax_mag, ax_phase) = plt.subplots(2, 1, figsize=(10, 10), sharex=True)

    fig, ax_mag = plt.subplots(figsize=(10, 6))

    # Plot impedance (magnitude) in the first subplot
    color = 'tab:red'
    ax_mag.plot(frequency, impedance, linewidth=3, label='Magnitude', color=color)

    # Configure the magnitude plot (top) with logarithmic y-axis and custom ticks
    ax_mag.set_xscale('log')
    ax_mag.set_yscale('log')
    ax_mag.set_xlim(0.1, 1e5)
    ax_mag.set_xlabel('Frequency (Hz)', fontsize=20)
    ax_mag.set_ylabel('Magnitude (Ω cm$^\mathrm{2}$)', fontsize=20, color=color)
    ax_mag.grid(True, which="both", ls="--")

    # Custom ticks for the magnitude plot
    ax_mag.tick_params(axis='y', which='major', labelsize=18, labelcolor=color)
    ax_mag.tick_params(axis='x', which='major', labelsize=18)
    ax_mag.xaxis.set_major_locator(plt.LogLocator(base=10.0, numticks=5))
    ax_mag.xaxis.set_minor_locator(plt.LogLocator(base=10.0, subs='auto', numticks=10))
    ax_mag.yaxis.set_major_locator(plt.LogLocator(base=10.0, numticks=5))

    ax_phase = ax_mag.twinx() # remove to plot on different windows

    # Plot phase in the second subplot
    color = 'tab:blue'
    ax_phase.plot(frequency, phases, linewidth=3, label='Phase', color=color)

    # Configure the phase plot (bottom) with logarithmic x-axis and custom ticks
    ax_phase.set_ylim(0, -80)
    ax_phase.set_xlabel('Frequency (Hz)', fontsize=20)
    ax_phase.set_ylabel('Phase (°)', fontsize=20, color=color)

    # Custom ticks for the phase plot
    ax_phase.tick_params(axis='y', which='major', labelsize=18, labelcolor=color)
    ax_phase.xaxis.set_major_locator(plt.LogLocator(base=10.0, numticks=5))
    ax_phase.xaxis.set_minor_locator(plt.LogLocator(base=10.0, subs='auto', numticks=10))

    lines, labels = ax_mag.get_legend_handles_labels()
    lines2, labels2 = ax_phase.get_legend_handles_labels()
    ax_phase.legend(lines + lines2, labels + labels2, loc=0, fontsize=18)

    #plt.savefig("EIS_Abbott.pdf", bbox_inches="tight")
    plt.show()


plot_modulab_eis_data('C:\\VNS_manuscript\\data\\EIS_Abbott.csv')