"""
Created in 2025

@author: Konstantina Kolovou Kouri
"""

import numpy as np
import matplotlib.pyplot as plt


def main():
    files = [
        "C:/VNS_manuscript/data/5patterns_100Hz_1k.csv",
        "C:/VNS_manuscript/data/5patterns_100Hz_1kR.csv",
        "C:/VNS_manuscript/data/5patterns_100Hz_100kR.csv",   
    ]
    for path in files:
        with open(path) as f:
            s = f.read()
        s = s.replace(",,", ",")
        with open(path, "w") as f:
            f.write(s)


    data1 = np.loadtxt(
        "C:/VNS_manuscript/data/5patterns_100Hz_1k.csv",
        delimiter=",",
        skiprows=21,
    ).T
    t1, ch2_1, ch3_1, td1, diff_1 = data1
    t1 *= 1000

    data5 = np.loadtxt(
        "C:/VNS_manuscript/data/5patterns_100Hz_1kR.csv",
        delimiter=",",
        skiprows=21,
    ).T
    t5, ch2_5, ch3_5, td5, diff_5 = data5
    t5 *= 1000

    data6 = np.loadtxt(
        "C:/VNS_manuscript/data/5patterns_100Hz_100kR.csv",
        delimiter=",",
        skiprows=21,
    ).T
    t6, ch2_6, ch3_6, td6, diff_6 = data6
    t6 *= 1000


    range_DC = int(len(t5))
    t5_DC = t5[:range_DC]
    diff_5_DC = diff_5[:range_DC]
    t6_DC = t6[:range_DC]
    diff_6_DC = diff_6[:range_DC]


    plt.figure(figsize = (9,6))
    plt.plot(t5_DC+2.01, diff_5_DC, color='grey', label = "1kΩ", linewidth=2.5)
    plt.plot(t6_DC+0.36, diff_6_DC, color='black', label = "100kΩ", ls='--', linewidth=2.5)
    plt.fill_between(t1, 2, where=(t1>0) & (t1<2), facecolor='dodgerblue', alpha=.2)
    plt.fill_between(t1, -2, where=(t1>0) & (t1<2), facecolor='dodgerblue', alpha=.2)
    plt.fill_between(t1, 2, where=(t1>2) & (t1<4), facecolor='darkorange', alpha=.3)
    plt.fill_between(t1, -2, where=(t1>2) & (t1<4), facecolor='darkorange', alpha=.3)
    plt.fill_between(t1, 2, where=(t1>4) & (t1<6), facecolor='forestgreen', alpha=.2)
    plt.fill_between(t1, -2, where=(t1>4) & (t1<6), facecolor='forestgreen', alpha=.2)
    plt.fill_between(t1, 2, where=(t1>6) & (t1<8), facecolor='r', alpha=.2)
    plt.fill_between(t1, -2, where=(t1>6) & (t1<8), facecolor='r', alpha=.2)
    plt.fill_between(t1, 2, where=(t1>8) & (t1<9.64), facecolor='mediumpurple', alpha=.2)
    plt.fill_between(t1, -2, where=(t1>8) & (t1<9.64), facecolor='mediumpurple', alpha=.2)
    plt.fill_between(t1, 2, where=(t1>-0.74) & (t1<0), facecolor='mediumpurple', alpha=.1)
    plt.fill_between(t1, -2, where=(t1>-0.74) & (t1<0), facecolor='mediumpurple', alpha=.1)

    plt.ylim(-2.2, 2.2)
    plt.legend(fontsize=18, loc='lower left')
    plt.xlabel("Time (ms)", fontsize=20)
    plt.ylabel("Output Voltage (V)", fontsize=20)
    plt.tick_params(axis='both', which='major', labelsize=14)
    plt.grid()

    plt.tight_layout()
    #plt.savefig("5P_100Hz_pattern_visual.pdf", bbox_inches="tight")
    plt.show()


if __name__ == "__main__":
    main()
