% Progress script
timeMeasured=toc;
estimatedTimeLeft = timeEst(timeMeasured,Sim.NoTimeSteps-k);
message=[...
    '  Simulation time     : ' num2str(Sim.TimeSteps(k)) ' s\n' ... 
    '  Progress in percent : ' num2str(100*k/Sim.NoTimeSteps,3) ' %%\n'...
    '  Estimated time left : ' estimatedTimeLeft ' (hh:mm:ss)\n'...
    '  Mean wind direction : ' num2str(mean(U_ang)/pi*180,2) ' deg\n'...
    '  Mean wind speed     : ' num2str(mean(U_abs),2) ' m/s\n'...
    '  Mean turbulence     : ' num2str(mean(I_val)*100,2) ' %%\n'...
    ' =========================================== '];
dispstat(sprintf(message))

%% ===================================================================== %%
% = Reviewed: 2020.09.30 (yyyy.mm.dd)                                   = %
% === Author: Marcus Becker                                             = %
% == Contact: marcus.becker.mail@gmail.com                              = %
% ======================================================================= %