%================================================%
%           LOG_SMOOTH                           %
% ============================================== %
%   author: B.A.Witvliet, University of Twente   %
%   date:   10 january 2023                      %
%================================================%

function UrxOut = Log_Smooth(UrxIn,FilterType,DataType)

% - Define smoothing filter -
if strcmp(FilterType(1:8),'Gaussian')
    Residual = FilterType(9:length(FilterType));
    L = str2num(Residual);
    filtervector = gausswin(L);
else
    err=1; disp('This smoothing filter is unknown'); filtervector=[1];
end

windowsize=length(filtervector);

if windowsize==1
    % - No smoothing -
    UrxOut=UrxIn;
else
    % - Adding heading and trailing dummy cells -
    ldata = length(UrxIn);
    hwindow=ceil(windowsize/2); %half window length
    for i=1 : hwindow
        UrxIn=[UrxIn(1,:); UrxIn; UrxIn(ldata,:)];
    end

    % - Smoothing -
    if strcmp(DataType,'Lin')
        UrxIn=filter(filtervector,sum(filtervector),UrxIn);
    else
        if strcmp(DataType,'Log')
            UrxIn_lin=10.^(UrxIn./10);
            UrxIn_lin2=filter(filtervector,sum(filtervector),UrxIn_lin);
            UrxIn=10*log10(UrxIn_lin2);
        else
            disp('Smoothing: Unknown datatype specified, only <Log> and <Lin> accepted'); 
            return;
        end %if
    end %if

    % Removing heading and trailing dummy cells + delay caused by filter -
    ldata=length(UrxIn);
    re=abs(windowsize-2*hwindow); %to correct for rounding error
    UrxOut=UrxIn(windowsize+re:ldata-1,:);
end %if

% - Cleanup memory -
clear filervector windowsize ldata hwidow i re;