%==============================================================%
%                X-FLARE AMBIENT NOISE DROP                    %
% ============================================================ %
%   author: B.A.Witvliet, University of Twente                 % 
%   date:   10 january 2023                                    %
%   code:   Matlab 2021b Update 1 (Nov. 2021)                  %
% ============================================================ %
%   When resusing this code, please acknowledge the original   %
%   author.                                                    %
%   When reusing this dataset, please cite the original        %
%   publication, which contains the associated background      %
%   information:                                               %
%   Witvliet, Ben A., et al. Impact of a Solar X-Flare on NVIS %
%   Propagation: Daytime characteristic wave refraction and    %
%   nighttime scattering. IEEE Ant.& Prop. Mag. 58.6 (2016).   %
%==============================================================%

% - Clear memory -
close all; clear; clc;  

%- User selected settings -
FileName  = 'B.A.Witvliet NVIS CIRC3 Delden Oct-2014.mat';
InputDir  = '.';
OutputDir = '.';
fontsz    = 32;
maxlevel  = 30; %dBuV
minlevel  = -40;   

%- Color settings -
col_hi = [0   0   1];  %blue
col_lo = [0.2 0.4 1];  %blue-blue'ish 

%- Load data file -
disp('Loading data from file...');
load('Dataset 1 B.A.Witvliet NVIS CIRC3 Xflare.mat'); 

% ----------------------------------
% CREATE GRAPH SPACE (CANVAS)
% ----------------------------------
disp('Creating graphs...');

% - Prepare a fullscreen graph space -
scrsz = get(0,'ScreenSize');  
graph = figure('Position',scrsz,'Color','white');     

% - Create two axes (graph subspaces) -
Axe{1} = [.09  .25  .75  .72];
axes('position',Axe{1},'FontSize',fontsz); %graph subspace 1 or 2

% ----------------------------------
% PLOT TIME GRAPH
% ----------------------------------

% - Plot time graph -
plot(GMT,Urx,'Color',col_lo,'LineStyle','none','Marker','+','MarkerSize',3, ...
          'MarkerFaceColor',col_lo, 'MarkerEdgeColor',col_lo); 
hold on;

% - Add floating average -
FilterType = 'Gaussian181';
Urx_sm     = Log_Smooth(Urx,FilterType,'Log');

% - Manually add average lines -
lwd = 1.5;
style = '-';
col_hi = [0 0 0.8];
GMT_trace = datenum({'22-Oct-2014 09:00:00', '22-Oct-2014 10:10:00', '22-Oct-2014 11:10:00', '22-Oct-2014 11:40:00', '22-Oct-2014 12:10:00', '22-Oct-2014 12:40:00', '22-Oct-2014 14:06:30'});
Urx_trace =        [ -10.5;                     -10.5;                  -11.4;                -11.4;                 -10.8;                 -9.7;                 -6.5];
plot( GMT_trace, Urx_trace,'Color',col_hi, 'LineWidth',lwd, 'LineStyle',style);
%
GMT_trace = datenum({'22-Oct-2014 14:07:30', '22-Oct-2014 14:12:00', '22-Oct-2014 14:28:00', '22-Oct-2014 14:38:00', '22-Oct-2014 14:44:00', '22-Oct-2014 15:00:00', '22-Oct-2014 15:15:00'});
Urx_trace =        [ -17.9;                   -17.9;                 -17.9;                   -17.3;                  -16.4;                  -11.5;                 -8];
plot( GMT_trace, Urx_trace,'Color',col_hi, 'LineWidth',lwd, 'LineStyle',style);
%
GMT_trace = datenum({'22-Oct-2014 15:15:00', '22-Oct-2014 15:30:00', '22-Oct-2014 16:00:00', '22-Oct-2014 16:10:00', '22-Oct-2014 16:40:00', '22-Oct-2014 17:40:00'});
Urx_trace =        [ -8;                   -5.9;                     -3.7;                     -3.5;                     -3.9;                   -7];
plot( GMT_trace, Urx_trace,'Color',col_hi, 'LineWidth',lwd, 'LineStyle',style);
%
GMT_trace = datenum({'22-Oct-2014 17:40:00', '22-Oct-2014 18:10:00', '22-Oct-2014 19:30:00', '22-Oct-2014 20:10:00', '22-Oct-2014 22:00:00', '23-Oct-2014 00:30:00'});
Urx_trace =        [ -7.0;                   -8.0;                     -9.5;                     -9.7;                     -10.2;                   -10.2];
plot( GMT_trace, Urx_trace,'Color',col_hi, 'LineWidth',lwd, 'LineStyle',style);

% - Interpolated line -
style = '--';
col_hi = 'red';
GMT_trace = datenum({'22-Oct-2014 14:05:00',  '22-Oct-2014 14:50:00', '22-Oct-2014 16:05:00'});
Urx_trace =        [ -6.5;                     -5.0;                     -3.5];
%plot( GMT_trace, Urx_trace,'Color',col_hi, 'LineWidth',lwd, 'LineStyle',style);

% - Time markers -
startday = floor(min(GMT));
TimeTicks = startday + (1:24)/48;
xticks(TimeTicks);
datetick('x','HH:MM','keeplimits');

% - Annotation: arrow X-flare strikes
t = datenum('22-Oct-2014 14:06:00');
y = 1;
dt = 5/60/24;
dy = 3;
plot([t    t],[y+8  y],'Color','red','LineWidth',3); %arrow stem
plot([t-dt t],[y+dy y],'Color','red','LineWidth',3); %arrowhead
plot([t+dt t],[y+dy y],'Color','red','LineWidth',3); %arrowhead
text(t,y+10.5,'Solar X-flare','HorizontalAlignment','center','FontSize',fontsz);

% -  Plot make-up -      
axis([min(GMT) max(GMT) minlevel maxlevel]); 
xlabel('Time  [UTC]  \rightarrow');
ylabel('Receiver voltage [dBuV] \rightarrow');
grid on;
set(gca,'Fontsize',fontsz,'XTickLabelRotation',90);
disp('Done');