<img src="../img/OperationAIR_Name.png" alt="OperationAIR_Name" style="zoom:10%;" />

# SERVICE STRUCTURE

In this document you will find an overview of included services that are offered to hospitals, aiming to optimize the use of the AIRone ventilator. The service accompanying the AIRone is provided by a service team of OperationAIR. Summarized, the service will consist of the following activities and means:

## Instruction day

With the implementation of the AIRone ventilator an instruction day is offered, on which two team
members will be visiting the hospital and stay stand-by for the duration of six hours. The instruction day will (depending on ICU requests) consist of:

- Training of key-users,
- Installation support of AIRone ventilators,
- Maintenance instructions to medical technology staff of the ICU department and,
- Explanation of service structure.

## Documentation

All (key) users will be provided with documentation, including (technical) manuals, training documents and maintenance instructions. These documents will also be made available through online platforms.

## Service desk

Questions and/or remarks can be communicated to the service team through the email-address or regular phone number. In case of emergency, hospitals can contact the service team through the emergency phone number which is 24/7 available. These services consist of training, support and maintenance. This is further elucidated in the following sections.

### Training

To optimize training of professionals and ensure safe use of the AIRone ventilator, a training plan has been developed in cooperation with a medical-educational specialist. The trainings consists of a combination of training-, communication- and support structures.

The service team will hold responsibility for training key-users (as defined by the hospital department, often medical ventilation experts). The hospital/department (ICU) will hold responsibility of other users and registration of trained professionals. The training of other users will be supported by the provided training material. The service team can be contacted either though telephone or e-mail for questions or remarks. 

### Key-user training (train-the-trainer)
To get familiar with the use of the AIRone ventilator, key-users will be given an explanation of the basic principles and will be given instructions on how to use the ventilator. The key-users and staff required to follow the training are defined by the hospital department. To ensure efficiency, a minimum of two key-users have to be present at the training. The training will take approximately 20 minutes, in which the training layout can be adjusted based on availability staff receiving training.

*Other users*

Key-users that have followed the training(trainers) will be training other users. It is the responsibility of the head of department/teammanager to ensure every user of the AIRone ventilator is trained in using the device. Healthcare professionals that have received training from a key-user/trainer will be registered by means of a list that is present on the department. This is meant to provide a clear overview of all personnel that is training in using the ventilator.

*OperationAIR teachers*

Service team members of OperationAIR that train key-users, are provided with an extensive (technical) manual. Also, a general meeting is held (in line with local guidelines on disease control), in which didactic skills, responsibilities, use of the device, and possible issues and questions are discussed. Only team members that have attended this meeting and that have read the extensive manual will be giving training to key-users.

### Instruction day support

During the instruction day, team members of OperationAIR will be present on-site to provide support in installation of the AIRone ventilator and to answer questions. If possible, these team members can provide additional training to other users.

### Training material

Training material will be available in the form of:

- <u>Powerpoint presentation</u>: Train-the-trainer 

  Key-users will be trained in using the AIRone ventilator with a presentation. The slides
  will be shared, so key-users and other uses can consult them retrospectively.

- <u>LearningSpace</u>

  An online performance-support platform is available containing all necessary information
  regarding safe use of the AIRone ventilator. This learning space can also be consulted
  outside of the hospital.
  In this learning space a description is given for different processes: installation, set-up,
  control and disconnection. Also, the more complex actions will be further explained.
  Finally, the learning space contains an FAQ-list containing answers and solutions to
  frequently asked questions. The learning space will be continuously updated based on
  practical experiences.

- <u>User manual</u>

  An extensive user manual will be offered to the department and is also available through
  the learning space.

- <u>Hand-out manual</u>

  A short, visually attractive summary will be offered, which can be placed in patient
  rooms or break rooms. Through this hand-out, users can get a quick recap on safely
  using the AIRone ventilator. On this hand-out, the emergency phone number will also be
  provided, as well as an overview of alarms and a QR-code to the Learning space.

## Maintenance and support

During the instruction day, the medical technology manager of the department (ICU) will be given an introduction to the AIRone ventilator and an explanation about possible maintenance that has to be performed on the device. Also, he/she will be given the technical manual, containing all relevant technical details with extensive descriptions.
In the case of technical issues in using the AIRone ventilator, the service team can be contacted
through the following channels:

```
Emergency ---------------> Contact emergency phone number 
							(24/7 available)
Non-emergency ---------------> Contact regular phone number or email 
							(9:00-17:00h available)
```


The **emergency telephone** is available 24/7 and will be held by team members of the service team with in-depth knowledge of the technical design of the AIRone ventilator. They will be able to directly advise the user. In the case of insufficient ability to give advice through the phone, a service team member will be coming to the hospital as soon as possible to provide on-site support in solving technical issues.

In cases that do not require direct technical support (non-emergency), the service team can be
contacted to the **regular phone number** or the **e-mail address**. Both will be managed by team
members with in-depth knowledge of the technical design of the AIRone ventilator. The user will
receive support through the phone. If necessary, a team member will be coming to the hospital to
provide on-site support. This phone number and e-mail address can also be used for other questions and/or technical issues.

All technical issues emerging from using the AIRone ventilator will be strictly monitored and evaluated. In this way, often occurring issues can be detected and solutions can be found.

Post-market surveillance will be performed. Several days after introduction of the AIRone ventilator in a hospital, the team will actively contact the users to evaluate the use of the device and answer questions. In this way, input can be collected for further development of the AIRone ventilator.