import pandas as pd
from argparse import ArgumentParser
import matplotlib.pyplot as plt
import numpy as np


def plot_data(data, x_param_name, y_param_name):
    means_of_y = {}
    stds_of_mean_of_y = {}
    x_values = pd.unique(data[x_param_name]).tolist()
    x_values.sort()
    for x_value in x_values:
        mean_of_y = data[data[x_param_name] == x_value][y_param_name].mean()
        std_of_mean_of_y = data[data[x_param_name] == x_value][y_param_name].std()
        std_of_mean_of_y = std_of_mean_of_y / np.sqrt(len(data[data[x_param_name] == x_value]))
        means_of_y[x_value] = mean_of_y
        stds_of_mean_of_y[x_value] = std_of_mean_of_y
    plt.errorbar(x=x_values, y=[means_of_y[x_value] for x_value in x_values],
                 yerr=[stds_of_mean_of_y[x_value] for x_value in x_values])
    plt.xlabel(x_param_name)
    plt.ylabel(y_param_name)
    plt.show()


parser = ArgumentParser()
parser.add_argument('csv_data_file', type=str, help='Name of CSV file containing data to plot.')
parser.add_argument('--num_repeaters', '-nr', action='store_true',
                    help='Plot the number of repeaters.')
parser.add_argument('--connectivity', '-c', action='store_true',
                    help='Plot the number of repeaters.')
args = parser.parse_args()
data = pd.read_csv(args.csv_data_file)
[scan_param_name] = [column for column in data.columns if column not in ['number_of_repeaters', 'connectivity']]
if args.num_repeaters:
    plot_data(data=data, x_param_name=scan_param_name, y_param_name="number_of_repeaters")
if args.connectivity:
    plot_data(data=data, x_param_name=scan_param_name, y_param_name="connectivity")
