reset
set terminal push
x=8.6
No=1.6180339887
set terminal epslatex standalone linewidth 2 rounded \
  dashlen 4 color '' 10 size (x)cm,(x/No)cm
set output 'epslatex.tex'
set encoding iso_8859_1
set format x '$10^{%L}$'
set format y '$10^{%L}$'
set xlabel '$St_1$'
set ylabel '$\tau$'
set mxtics 10
set mytics 10
set style line 12 lc rgb '#ddccdd' lt 1 lw 1.5
set style line 13 lc rgb '#ddccdd' lt 1 lw 0.5
set grid xtics mxtics ytics mytics back ls 12, ls 13
set key left bottom

f(x) = (x>1 && x<50) ? 0.0016*x**(-1./2.) : 1/0
#set label '$t^{-1/2}$' at 5,0.0002 left front

h(x) = (x>1 && x<50) ? 0.03*x**(-1./4.) : 1/0
#set label '$t^{-1/4}$' at 5,0.03 left front

#set label '$h_{min}(t)$' at 0.01,0.005 left front
#set label '$H(0,t)$' at 0.1,0.05 left front

g(x) = (x>1 && x<50) ? 0.010*x**(-2./3.) : 1/0

file1='S/Hmin.txt'
file2='L/Hmin.txt'

set log; 
set grid; 
set linetype 1 lc rgb 'black'; 
set linetype 2 lc rgb '#222222'; 
set linetype 3 lc rgb '#444444';
set linetype 4 lc rgb '#666666'; 
set linetype 5 lc rgb '#888888';
set linetype 6 lc rgb '#AAAAAA';
set linetype 7 lc rgb '#CCCCCC'; 

set linetype 1 lc rgb '#0065a5'; 
set linetype 2 lc rgb '#535aa5'; 
set linetype 3 lc rgb '#804b98';
set linetype 4 lc rgb '#a0387d'; 
set linetype 5 lc rgb '#b12a5a';
set linetype 6 lc rgb '#b32d33';
set linetype 7 lc rgb '#a54000'; 


plot 'time.txt' u 2:3 w lp pt 7 lt 1 ps 1 t '',\
'time2.txt' u 2:3 w lp pt 7 lt 2 ps 1 t '',\
'time3.txt' u 2:3 w lp pt 7 lt 3 ps 1 t '',\
'time4.txt' u 2:3 w lp pt 7 lt 4 ps 1 t '',\
'time5.txt' u 2:3 w lp pt 7 lt 5 ps 1 t '',\
'time6.txt' u 2:3 w lp pt 7 lt 6 ps 1 t '',\
'time7.txt' u 2:3 w lp pt 7 lt 7 ps 1 t '',\
49.408000000000001251 w l lt 1 dt 3 lc rgbcolor 'black' t '',\
88.814000000000007162 w l lt 1 lc rgbcolor 'black' t ''
unset log

