reset
set terminal push
x=8.6
No=1.6180339887
set terminal epslatex standalone linewidth 2 rounded \
  dashlen 4 color '' 10 size (x)cm,(x/No)cm
set output 'epslatex.tex'
set encoding iso_8859_1
set format x '$10^{%L}$'
set format y '$10^{%L}$'
set xlabel '$t$'
set mxtics 10
set mytics 10
set style line 12 lc rgb '#ddccdd' lt 1 lw 1.5
set style line 13 lc rgb '#ddccdd' lt 1 lw 0.5
set grid xtics mxtics ytics mytics back ls 12, ls 13
set key left bottom

f(x) = (x>1 && x<50) ? 0.0016*x**(-1./2.) : 1/0
#set label '$t^{-1/2}$' at 5,0.0002 left front

h(x) = (x>1 && x<50) ? 0.03*x**(-1./4.) : 1/0
#set label '$t^{-1/4}$' at 5,0.03 left front

#set label '$h_{min}(t)$' at 0.01,0.005 left front
#set label '$H(0,t)$' at 0.1,0.05 left front

g(x) = (x>1 && x<50) ? 0.010*x**(-2./3.) : 1/0

file1='S/Hmin.txt'
file2='L/Hmin.txt'

set log; 
plot [][1e-4:] 'm1/Hmin.txt' u 1:3 w l t '',\
'0/Hmin.txt' u 1:3 w l t '',\
'1/Hmin.txt' u 1:3 w l t '',\
'2/Hmin.txt' u 1:3 w l t '',\
'3/Hmin.txt' u 1:3 w l t '',\
'4/Hmin.txt' u 1:3 w l t '',\
'5/Hmin.txt' u 1:3 w l t '',\
'6/Hmin.txt' u 1:3 w l t '',\
'7/Hmin.txt' u 1:3 w l t '',\
'8/Hmin.txt' u 1:3 w l t '',\
'9/Hmin.txt' u 1:3 w l t '',\
'10/Hmin.txt' u 1:3 w l t '',\
'11/Hmin.txt' u 1:3 w l t '',\
'12/Hmin.txt' u 1:3 w l t '',\
0.0008 w l lt 3 lc "black" t ''
unset log

