#include "utilf.h"
#include "global.h"
#include "markers.h"
#include "ini_conditions.h"
#include <time.h>
#include "integral.h"
#include "phi_moy.h"
#include "time_step.h"
#include <time.h>
#include <glib.h>

void viz(double *r,double *h1,double *H,int n,double *p1,double *p2, double t)
{
	int i;
	double fact = 10.0;
	double fact2= 50.0;

	  printf("set title 't = %.3f'\n",t);
	  printf("set style fill transparent solid 0.1 border lc rgb 'blue'\n");

	  printf("set size ratio 0.5\n");
	  printf("plot [%g:%g][0:0.1] '-' u 1:2 w filledcurves above y1=-10 lt 1 lc rgb 'blue' lw 2 t '', '-' u 1:2 w filledcurves below y1=10 lt 1 lc rgb 'blue' lw 2 t '', '-' u 1:2 w l lt 1 lc rgb 'red' lw 2 t 'H=h2-h1', '-' u 1:2 w l lt 1 lc rgb 'black' lw 2 t 'p1', '-' u 1:2 w l lt 1 lc rgb 'green' lw 2 t 'p2'\n",0.0,1.0);
	for (i=n-1; i>=1; i--){
		printf("%.20g %.20g\n",-r[i],h1[i]);
	}
	for (i=0; i<=n-1; i++){
		printf("%.20g %.20g\n",r[i],h1[i]);
	}
  	printf("e\n");
	printf("\n");
	for (i=n-1; i>=1; i--){
		printf("%.20g %.20g\n",-r[i],h1[i]+H[i]);
	}
	for (i=0; i<=n-1; i++){
		printf("%.20g %.20g\n",r[i],h1[i]+H[i]);
	}
	  printf("e\n");
	printf("\n");
	for (i=n-1; i>=1; i--){
		printf("%.20g %.20g\n",-r[i],H[i]*fact);
	}
	for (i=0; i<=n-1; i++){
		printf("%.20g %.20g\n",r[i],H[i]*fact);
	}
	  printf("e\n");
	printf("\n");
	for (i=n-1; i>=1; i--){
		printf("%.20g %.20g\n",-r[i],p1[i]/fact2);
	}
	for (i=0; i<=n-1; i++){
		printf("%.20g %.20g\n",r[i],p1[i]/fact2);
	}
	  printf("e\n");
	printf("\n");
	for (i=n-1; i>=1; i--){
		printf("%.20g %.20g\n",-r[i],p2[i]/fact2);
	}
	for (i=0; i<=n-1; i++){
		printf("%.20g %.20g\n",r[i],p2[i]/fact2);
	}
	  printf("e\n");
	printf("\n");
}
