#include "utilf.h"
#include "global.h"
#include <stdio.h>
#include "time_step.h"
#include "interpolation.h"
#include "markers.h"
#include "ini_conditions.h"
#define PLOT 0

int time_step(int it, double *r, double *h1, double *dh1dt, double *H, double *dHdt, int n, double dt, double Bo, double St1, double St2, double h0, double Hp, double S)
{
	int i;
	double dr = r[1]-r[0];
	double dr2=dr*dr;
	double dr3=dr*dr*dr;
	double dr4=dr*dr*dr*dr;
	double *h1_temp,*H_temp;
	double *pressure;
	double hi,him1,hip1,d2hdr2;
	double mH = 0.0;
	double mp = 0.0;
	double fact = 10;
	double tmp = 0.0;

	/****************************************/ 
  	pressure = (double *)malloc(n * sizeof(double));
	h1_temp = (double *)malloc(n * sizeof(double));
	H_temp = (double *)malloc(n * sizeof(double));
	/****************************************/ 


	/****************************************/ 

#if 0
	fprintf(stderr, "\rt = %4d     Tphys =%.6f     Time_step =%g "
			"      N = %d",
			t, num->t, num->tau, sx->n);
	fflush(stdout);
#endif  

	/******************************************************/
	for (i=0; i<=n-1; i++){
		h1_temp[i] = h1[i];
		H_temp[i] = H[i];
	}
	/******************************************************/
	euler_SI(it,r,dt,h1_temp,dh1dt,H_temp,dHdt,n,Bo,St1,St2,h0,Hp,S);
	/******************************************************/
	euler_SI(it,r,0.5*dt,h1,dh1dt,H,dHdt,n,Bo,St1,St2,h0,Hp,S);
	euler_SI(it,r,0.5*dt,h1,dh1dt,H,dHdt,n,Bo,St1,St2,h0,Hp,S);
	/******************************************************/
	for (i=0; i<=n-1; i++){
		h1[i] = 2.0*h1[i] - h1_temp[i];
		H[i] = 2.0*H[i] - H_temp[i];
	}
	/*******************************************************************/
	/* Compute mean height H */
	mH = 0.0;
	for (i=0; i<=n-2; i++){
		mH += 0.5*dr*(H[i]+H[i+1]);
	}
	/*fprintf(stderr,"\nmH = %g \n",mH);*/
	/*for (i=0; i<=n-1; i++){*/
		/*H[i] += 0.1-mH;*/
	/*}*/
	/*mH = 0.0;*/
	/*for (i=0; i<=n-2; i++){*/
		/*mH += 0.5*dr*(H[i]+H[i+1]);*/
	/*}*/
	/*fprintf(stderr,"\nmH = %g \n",mH);*/
	/* Compute mean height H */
	/*******************************************************************/
#if 1
/* COMPUTE THE PRESSURE */
	for (i=0; i<=n-1; i++){
		if (i==0){
			him1 = h1[1]+H[1];
			hi = h1[i]+H[i];
			hip1 = h1[i+1]+H[i+1];
			d2hdr2 = (him1-2.0*hi+hip1)/dr2;
			pressure[i] = -hi-d2hdr2/Bo;
		}
		else if (i==n-1){
			him1 = h1[i-1]+H[i-1];
			hi = h1[i]+H[i];
#if 1
			hip1 = h1[i-1]-h1[i]*2*dr*sqrt(Bo)+2*dr*sqrt(Bo)*h0 +2*dr*Hp+H[i-1]+2.0*dr*sqrt(Bo)*h1[i]-2.0*dr*sqrt(Bo)*h0;
#else
			hip1 = h1[i-1]+2*dr*Hp+H[i-1];
#endif
			d2hdr2 = (him1-2.0*hi+hip1)/dr2;
			pressure[i] = -hi-d2hdr2/Bo;
		}
		else{
			him1 = h1[i-1]+H[i-1];
			hi = h1[i]+H[i];
			hip1 = h1[i+1]+H[i+1];
			d2hdr2 = (him1-2.0*hi+hip1)/dr2;
			pressure[i] = -hi-d2hdr2/Bo;
		}
	}
	for (i=0; i<=n-1; i++){
			  pressure[i] -= pressure[n-1];
	}
	mp = 0.0;
	for (i=0; i<=n-2; i++){
		mp += 0.5*dr*(pressure[i]+pressure[i+1]);
	}
#if 0
	fprintf(stderr,"\nmp = %g \n",mp);
#endif

	tmp = -Hp/Bo*(1-2.0/dr)
		+(h1[n-1]+H[n-1])*(1-2.0/Bo/dr2)
		+(h1[n-2]+H[n-2])*(2.0/Bo/dr2)
		-dr/2.0*(h1[0]+H[0]+h1[n-1]+H[n-1]);
	for (i=1; i<=n-2; i++){
		tmp -= dr*(h1[i]+H[i]);
	}
#if 0
	fprintf(stderr,"tmp = %g \n",tmp);
#endif
	/*exit(1);*/

/* COMPUTE THE PRESSURE */
#endif
#if PLOT
	  printf("set style fill transparent solid 0.1 border lc rgb 'blue'\n");

          /*printf("set size square -1\n");*/
	  printf("set size ratio 0.5\n");
          /*printf("set style fill solid 0.3 border lc rgb 'gray10'\n");*/
	  printf("plot [%g:%g][0:0.1] '-' u 1:2 w filledcurves above y1=-10 lt 1 lc rgb 'blue' lw 2 t '', '-' u 1:2 w filledcurves below y1=10 lt 1 lc rgb 'blue' lw 2 t '', '-' u 1:2 w l lt 1 lc rgb 'red' lw 2 t 'H=h2-h1', '-' u 1:2 w l lt 1 lc rgb 'green' lw 2 t 'pressure'\n",0.0,1.0);
	for (i=n-1; i>=1; i--){
		printf("%.20g %.20g\n",-r[i],h1[i]);
	}
	for (i=0; i<=n-1; i++){
		printf("%.20g %.20g\n",r[i],h1[i]);
	}
  	printf("e\n");
	printf("\n");
	for (i=n-1; i>=1; i--){
		printf("%.20g %.20g\n",-r[i],h1[i]+H[i]);
	}
	for (i=0; i<=n-1; i++){
		printf("%.20g %.20g\n",r[i],h1[i]+H[i]);
	}
	  printf("e\n");
	printf("\n");
	for (i=n-1; i>=1; i--){
		printf("%.20g %.20g\n",-r[i],H[i]*fact);
	}
	for (i=0; i<=n-1; i++){
		printf("%.20g %.20g\n",r[i],H[i]*fact);
	}
	  printf("e\n");
	printf("\n");
	for (i=n-1; i>=1; i--){
		printf("%.20g %.20g\n",-r[i],pressure[i]/10.0);
	}
	for (i=0; i<=n-1; i++){
		printf("%.20g %.20g\n",r[i],pressure[i]/10.0);
	}
	  printf("e\n");
	printf("\n");
#endif

	free(h1_temp);
	free(H_temp);
	free(pressure);

	return 1;

	}


