#include "utilf.h"
#include "global.h"
#include "markers.h"
#include "ini_conditions.h"
#include <time.h>
#include "integral.h"
#include "phi_moy.h"
#include "time_step.h"
#include <time.h>
#include <glib.h>
#define MARK 1


int main(int argc, char *argv[])
{
	int i,n,tsave,itmax,it;
	double dt,Bo,St1,St2,t=0;
	double delta,beta;
	double Hp,S;
	double *r, *H, *dHdt;
	double *h1, *dh1dt;
	double h0=1;
  	GKeyFile *keyfile;
  	GKeyFileFlags flags;
  	GError *error = NULL;
  	char config[256];
	clock_t start, end;
	double cpu_time_used;
	double count;
	double rhmin,hmin;
	int ihmin;
	double hmax1,rhmax2,hmax2,dhdr,Hmoy,dr;
	double Q1,Q2,Q3;
	double *p1, *p2;
	int test;
	FILE *fptr = fopen("Hmin.txt", "wt");
	FILE *fout = fopen("fout.txt", "wt");
	FILE *fmark;

/************************************************************************/
	if (argc==1){
		fprintf(stderr,"Using default config file ""'config.txt'""\n");
		sprintf(config,"config.txt");
	}
	else{
		sprintf(config,argv[1]);
	}
/************************************************************************/
  keyfile = g_key_file_new ();
  flags = G_KEY_FILE_KEEP_COMMENTS | G_KEY_FILE_KEEP_TRANSLATIONS;
  
  if (!g_key_file_load_from_file (keyfile, config, flags, &error))
  {
    g_error (error->message);
    return -1;
  }
  
  /**
   * Numerical parameters
   */

  n = g_key_file_get_integer     (keyfile, "numerics", "n", NULL);
  dt = g_key_file_get_double     (keyfile, "numerics", "dt", NULL);
  itmax = g_key_file_get_integer     (keyfile, "numerics", "itmax", NULL);

  /**
   * Physical parameters
   */

  Bo = g_key_file_get_double     (keyfile, "physics", "Bo", NULL);
  h0 = g_key_file_get_double     (keyfile, "physics", "h0", NULL);
  St1 = g_key_file_get_double     (keyfile, "physics", "St1", NULL);
  St2 = g_key_file_get_double     (keyfile, "physics", "St2", NULL);
  Hp = g_key_file_get_double     (keyfile, "physics", "Hp", NULL);
  S = g_key_file_get_double     (keyfile, "physics", "S", NULL);

  /**
   * Output parameters
   */

  tsave = g_key_file_get_integer     (keyfile, "output", "tsave", NULL);

/************************************************************************/
  r = (double *)malloc(n * sizeof(double));
  h1 = (double *)malloc(n * sizeof(double));
  dh1dt = (double *)malloc(n * sizeof(double));
  H = (double *)malloc(n * sizeof(double));
  dHdt = (double *)malloc(n * sizeof(double));
  p1 = (double *)malloc(n * sizeof(double));
  p2 = (double *)malloc(n * sizeof(double));
/************************************************************************/
/************************************************************************/
  /*printf("plot '-' u 1:2 w l\n");*/
  for (i=0;i<=n-1;i++){
	  r[i] = (double) i / (double)(n-1);
	  /* r[n-1] = 1 */
	  h1[i] = h0;
	  H[i] = 2*h0;
	  /*H[i] = 0.1 + r[i]*r[i]*r[i]*r[i]/24.0 + 5.0/12.0*r[i]*r[i];*/
	  /*H[i] = r[i]*r[i]/2.0;*/
	  /*h1[i] = r[i]*r[i]/4.0;*/
  }

	fprintf(stderr,"\n################################\n");
	fprintf(stderr,"Bo = %g                  \n",Bo);
	/*fprintf(stderr,"St1 = %g                 \n",phys->St1);*/
	/*fprintf(stderr,"St2 = %g                 \n",phys->St2);*/
	/*fprintf(stderr,"dt_max = %-12.3g                 \n",6.*phys->St1*phys->Bo*dx*dx*dx*dx/(h1[0]*h1[0]*h1[0]*PI*PI*PI*PI));*/
	fprintf(stderr,"dt = %g                 \n",dt);
	/*fprintf(stderr,"################################\n");*/
	/*fprintf(stderr,"\n################################\n");*/
	fprintf(stderr,"delta = %g                  \n",delta);
	fprintf(stderr,"beta = %g                  \n",beta);
	fprintf(stderr,"Hp = %g                  \n",Hp);
	fprintf(stderr,"S = %g                  \n",S);
	fprintf(stderr,"################################\n");

	fprintf(fptr,"# t rHmin Hmin rHmax1 Hmax1 rHmax2 Hmax2\n");

for (it=0; it<=itmax; it++) {
#if 1
	fprintf(stderr, "\rt = %.6f     Time_step =%g      hmin = %.6f",
			it*dt, dt, hmin);
	fflush(stdout);
#endif  
/*[>********************************************************************<]*/
	/*start = clock();*/
	t = it * dt;
	count = time_step(it,r,h1,dh1dt,H,dHdt,n,dt,Bo,St1,St2,h0,Hp,S);
	comp_p(r,h1,H,h0,Hp,n,Bo,p1,p2);

#ifdef gnuX
	viz(r,h1,H,n,p1,p2,t);
#endif


	hmax1 = H[0];
	rhmax2=0.0;
	hmax2=H[0];

	hmin = 1.0;
	ihmin = 1;
	test = 0;
  	for (i=1;i<=n-2;i++){
		dhdr = (h1[i+1]-h1[i-1])/(r[i+1]-r[i-1]);
		if (H[i]/(1.0+dhdr*dhdr)<=hmin){
			rhmin=r[i]; 
			hmin=H[i]/(1.0+dhdr*dhdr);
			ihmin = i;
		}
		/*if (H[i]>=H[i-1] && H[i+1]<=H[i]){rhmax2=r[i]; hmax2=H[i]; test=1;}*/
	}
	dr = r[1]-r[0];
	Hmoy = 0.5*dr*H[0];
  	for (i=1;i<=ihmin-1;i++){
		Hmoy += H[i]*dr;
	}
	Hmoy += 0.5*dr*H[ihmin];

	i = ihmin;
	Q1 = H[i]*H[i]*H[i]/3.0/St2*(p2[i+1]-p2[i-1])/dr;
	Q2 = h1[i]*h1[i]*H[i]/2.0/St1*(p1[i+1]-p1[i-1])/dr;
	Q3 = h1[i]*H[i]*H[i]/St1*(p2[i+1]-p2[i-1])/dr;


	/*if (test==0)*/
		/*fprintf(fptr,"%.20g %.20g %.20g %.20g %.20g %.20g\n",*/
			/*t,rhmin,hmin,0.0,hmax1,Hmoy);*/
	/*else*/
		fprintf(fptr,"%.20g %.20g %.20g %.20g %.20g %.20g %.20g %.20g %.20g\n",
				t,
				rhmin,
				hmin,
				0.0,
				hmax1,
				Hmoy,
				Q1,
				Q2,
				Q3);
		/*fprintf(fptr,"%.20g %.20g %.20g %.20g %.20g %.20g\n",t,rhmin,hmin,0.0,hmax1,Hmoy);*/





		/*fprintf(fptr,"%.20g %.20g %.20g %.20g %.20g %.20g %.20g %.20g\n",t,rhmin,hmin,0.0,hmax1,rhmax2,hmax2,Hmoy);*/
	/*fprintf(fptr,"%.20g %.20g\n",t,hmin);*/
	/*getchar();*/
	/*end = clock();*/
	/*cpu_time_used = ((double) (end - start)) / CLOCKS_PER_SEC;*/
	/*getchar();*/
/*[>********************************************************************<]*/
#if 0
	if (hmin<=0.03){
  	for (i=0;i<=n-1;i++){
		fprintf(fout,"%g %g\n",r[i],h2[i]);
	}
	exit(1);
	}
#endif

#if MARK
  if (it == 0){
	fmark = fopen("markers.xmgr", "wt");
  	fprintf(fmark, "# %d\n",it);
  	for (i=0; i<=n-1; i++)
		fprintf(fmark, "%g %g %g %g %g\n", 
		r[i],
		h1[i],
		H[i],
		p1[i],
		p2[i]);

  	fprintf(fmark, "\n");
  	fclose(fmark);
  }
  else if (it % 100 == 0){
	fmark = fopen("markers.xmgr", "at");
  	fprintf(fmark, "# %d\n",it);
  	for (i=0; i<=n-1; i++)
		fprintf(fmark, "%g %g %g %g %g\n", 
		r[i],
		h1[i],
		H[i],
		p1[i],
		p2[i]);

  	fprintf(fmark, "\n");
  	fclose(fmark);
  }
#endif

  /*if (hmin <= h0/300.0){*/
  /*if (hmin <= 0.001){*/
  /*if (hmin <= h0/5.0){*/
  /*if (hmin <= h0/1000.0){*/
	  /*fprintf(fout,"%g %g\n",30e-6/h0,t*sqrt(30e-6/h0/9.81));*/
	  fprintf(fout,"%.20g %.20g %.20g\n",hmin,St1,t);
	  /*exit(1);*/
  /*}*/
  if (hmin <= 1e-4){
	  exit(1);
  }

}

	/*double dx = phys->r_film/(double)(num->n_film-1);*/
	/*for (i = 0; i <= num->n_film - 1; i++) {*/
		/*h1[i] = phys->h_film;*/
	/*}*/
/************************************************************************/




return 0;

}
