#include "stypes.h"
#include "interpolation.h"

#define NOTENSION 0
#define TENSION_U 1
#define TENSION_V 2
#define NSEC 10
#define MASSPREC 1.e-3

#define TRUE_PERIODIC 1
#define APPROX_PERIODIC 2
#define AXITRUE 3
#define AXINATURAL 4
#define AXIBOTH 5
#define AXINULL 6

#define INTERPREC 1.e-6
#define MARK_TYPE 0
#define HOR_TYPE 1
#define VER_TYPE 2

extern void interface_write_markers(Surface surf, char *file);

extern void interface_write_splines(Surface surf, char *file, int nb);

extern void interface_write_curvature(Surface surf, FILE *fptr);

extern void interface_splines(Surface surf);

extern void interface_splines_without_arclength(Surface surf);

extern void interface_splines_with_old_arclength(Surface surf);

extern void gauss_points_redis(Surface Gsurf, Surface surf, int nint);

extern void gauss_function_redis(real *Gf, real *f, Surface surf, int nint);

extern real * interface_curvature(Surface surf);

extern void function_splines(Spline *sp);

extern real norm(real1D x, real1D y, int n);

extern real maximum(real1D x, int n);

extern real dist_min(real1D x, int n);

extern void redist(Surface surf, int np);

extern void redist_curvature(Surface surf, int np);

extern void function_redist(Spline *sf);

extern void interface_redist(Spline *sx, Spline *sy);

extern real interface_axisymmetry(real1D s, real1D x, int flag);

extern void smooth(Surface surf, real1D u, real1D v, real1D phi, real1D mu);

extern void smooth_simple(Surface surf, real1D phi, real1D mu);

extern void smooth_phimu(Surface surf, real1D phi, real1D mu);

extern void smooth_curvature(Surface surf, real1D phi, real1D mu);

extern void smooth_test(Surface surf, real1D phi, real1D mu);

extern real gauss(int i, real *kappa, real *s, real kappamax, int n);

extern void smooth_poly2(Surface surf, real1D phi, real1D mu);

extern Spline * spline_copy(Spline *s);

extern void write_polynoms(Surface surf, int nb);

extern void polint(double xa[], double ya[], 
		int n, double x, double *y, double *dy);

extern void polcoe(real *x, real *y, int n, real *cof);

extern void dadksi(real *x, real *un, int n, int nint);

extern void dsdlambda(Surface surf, real *lambda, int n);

extern real d2sdksi2(real *x, real *y, int n);

extern void redist_poly(int t, Surface surf, real1D *pphi, real1D *pmu);

extern real fint01(real *y, int n);

extern real polinterp(real xi, real *y, int n);
