/*----------------------------------------------------------------------------*/
/* SCCS Information: %W%    %G% */
/*----------------------------------------------------------------------------*/
#include <stdlib.h>
#include "stypes.h"

extern void readglob(PhysStruct *phys, NumStruct *num, OutStruct *out);

extern void initglobal();

extern void printhist(PhysStruct *phys, NumStruct *num, OutStruct *out);

extern void printnumbers(PhysStruct *phys);

extern void initialize(Surface surf, real *phi);

extern int fredholm(Surface surf, real *phi, real *mu, PhysStruct *phys, NumStruct *num); 

extern real ellintk(real m);

extern real ellinte(real m);

extern void dgreendn(int i, Spline *sx, Spline *sy, real *nr, real *nz, real *dgdn);

extern real dgreendn_fredholm(real r0, real z0, real r1, real z1, real nr, real nz, int i, int j, int ng);

extern real * dgreends(int i, Spline *sx, Spline *sy, real *tr, real *tz);

extern real * green(Surface surf, int i);

extern void velocity(Surface surf, real1D u, real1D v, real1D phi, real1D mu, 
		     PhysStruct *phys, NumStruct *num);

extern void normal(Surface surf, real1D nr, real1D nz, real1D tr, real1D tz);

extern void normal_fredholm(real1D sx, real1D sy, int n, real1D nr, real1D nz, real1D tr, real1D tz);

extern Spline * vector_to_spline(real *x, real *s, int flag, int n);

extern real axivolume(Surface surf);

extern void gauss_redist(real *x, real *y, real *mu, int nint, int n, 
		real *xg, real *yg, real *mug, real *lambda, int np);

extern void gauss_redist_mu(real *mu, int nint, int n, real *mug, int np);

extern double norm_abs(double * x, double * y, int n);

extern void normal2(Surface surf, real1D nr, real1D nz, real1D tr, real1D tz);

extern double l_dist(double *x, double *y, int n);

extern void rho_to_p(Surface surf, double *p, double *rho, int m, double gamma);

extern void p_to_rho(Surface surf, double *rho, double *p, double gamma, double Eu);

extern void rho_s(Surface surf, double *rho, double *rhos, int i_eq);

extern void h_s(Surface surf, double *hs, int i_eq);

extern void rho_ss(Surface surf, double *rho, double *rhoss, int i_eq);

extern void rhs_rhoh(Surface surf, double *rho, double *rhos, double *rhoss, double *hs, double *u, double *v, double *f_rhoh, double M, double gamma, int i_eq);

extern void solve_rho(double *x1, double *y1, double *x2, double *y2, int n, double *rho, int n2, double tau, double M, double gamma);

extern void diff_reg (Surface surf, double * x, double * y, double dt, double lambda, int i_eq);

extern int time_step_richardson_C(int t, Surface surf, real1D u, real1D v, real1D phi, real1D rho, int m, real1D mu, PhysStruct *phys, NumStruct *num);

extern void Flux(Surface surf, double *rho, double *rhos, double *flux, double gamma, int i_eq, PhysStruct *phys);

extern void Diff_r(Surface surf, double *f, double *fr, int i_eq);

extern void redist_height4(Surface surf, double **pu, double **pv, double **pphi, double **pmu, double **pp);

extern int time_step(int it, double *r, double *h1, double *dh1dt, double *h2, double *dh2dt, int n, double dt, double Bo, double St1, double St2, double h0, double Hp, double Hpp);
 
extern void save_pressure(int t, Surface surf, real *pf, PhysStruct *phys, NumStruct *num);

extern double * curvature_film(double *h, PhysStruct *phys, NumStruct *num);

extern void drop_to_grid(Surface surf, double * u, double * v, double * p2, PhysStruct *phys, NumStruct *num, double *h1, double *kappa1, double *dh1dt);

extern double smooth_step(double x);

extern int euler_SI(int it, double *r, double dt, double *h1, double *dh1dt, double *H, double *dHdt, int n, double Bo, double St1, double St2, double h0, double Hp, double S);

extern void comp_p(double *r, double *h1, double *H, double h0, double Hp, int n, double Bo, double *p1, double *p2);

extern void viz(double *r,double *h1,double *H,int n,double *p1,double *p2, double t);
