#include "utilf.h"
#include "global.h"
#include <stdio.h>
#include "time_step.h"
#include "interpolation.h"
#include "markers.h"
#include "ini_conditions.h"
#define TEST 0
#include <gsl/gsl_errno.h>
#include <gsl/gsl_spline.h>
#include <gsl/gsl_matrix.h>
#include <gsl/gsl_vector.h>
#include <gsl/gsl_permutation.h>
#include <gsl/gsl_linalg.h>
#include <gsl/gsl_math.h>
#include <gsl/gsl_permute_vector.h>
#include <gsl/gsl_blas.h>
#include <gsl/gsl_sort_vector.h>

int euler_SI(int it, double *r, double dt, double *h1, double *dh1dt, double *H, double *dHdt, int n, double Bo, double St1, double St2, double h0, double Hp, double S)
{
	int i,j,jH;
	double dr = r[1]-r[0];
	double dr2=dr*dr;
	double dr3=dr*dr*dr;
	double dr4=dr*dr*dr*dr;
	double A1,A2,A3,A4;
	double B1,B2,B3,B4;
	double C1,C2,C3,C4;
	double D1,D2,D3,D4;
	double h1p,hp;
	gsl_matrix *A;
	gsl_vector *B;
	gsl_permutation *per;
	int signum;
	/*double *pressure;*/
	double hi,him1,hip1,d2hdr2;

  	A = gsl_matrix_calloc(2*n,2*n);
  	B = gsl_vector_calloc(2*n);
  	per = gsl_permutation_calloc(2*n);

          /*pressure = (double *)malloc(n * sizeof(double));*/

/******************************************************************/
  for (i=0;i<=n-1;i++){
/******************************************************************/
	  jH = i+n;
/******************************************************************/
	  /* h1 */
/******************************************************************/
	  if (i==0){
		  h1p = 0;
		  hp = 0;
		  A1 = -h1[i]*h1[i]*h1p/St1 - h1[i]*h1p*H[i]/St1 - h1[i]*h1[i]*hp/2.0/St1;
		  A2 = -h1[i]*h1[i]/St1 * (h1[i]/3.0+H[i]/2.0);
		  A3 = -2.0*h1[i]*h1[i]*h1p/St1/Bo - h1[i]*h1p*H[i]/St1/Bo - h1[i]*h1[i]*hp/2.0/St1/Bo;
		  A4 = -h1[i]*h1[i]/St1/Bo * (2.0*h1[i]/3.0+H[i]/2.0);
		  B1 = A1;
		  B2 = A2;
		  B3 = A3 + h1[i]*h1[i]*h1p/St1/Bo;
		  B4 = A4 + h1[i]*h1[i]*h1[i]/3.0/St1/Bo;

		  gsl_matrix_set(A, i, i, -1.0/dt-2.0/dr2*A2+6.0/dr4*A4);
		  gsl_matrix_set(A, i, i+1, 2.0/dr2*A2-8.0/dr4*A4);
		  gsl_matrix_set(A, i, i+2, 2.0/dr4*A4);

		  gsl_matrix_set(A, i, jH, -2.0/dr2*B2+6.0/dr4*B4);
		  gsl_matrix_set(A, i, jH+1, 2.0/dr2*B2-8.0/dr4*B4);
		  gsl_matrix_set(A, i, jH+2, 2.0/dr4*B4);

		  gsl_vector_set(B, i, -h1[i]/dt);
	  }
	  else if (i==1){
		  h1p = (h1[i+1]-h1[i-1])/2.0/dr;
		  hp = (H[i+1]-H[i-1])/2.0/dr;
		  A1 = -h1[i]*h1[i]*h1p/St1 - h1[i]*h1p*H[i]/St1 - h1[i]*h1[i]*hp/2.0/St1;
		  A2 = -h1[i]*h1[i]/St1 * (h1[i]/3.0+H[i]/2.0);
		  A3 = -2.0*h1[i]*h1[i]*h1p/St1/Bo - h1[i]*h1p*H[i]/St1/Bo - h1[i]*h1[i]*hp/2.0/St1/Bo;
		  A4 = -h1[i]*h1[i]/St1/Bo * (2.0*h1[i]/3.0+H[i]/2.0);
		  B1 = A1;
		  B2 = A2;
		  B3 = A3 + h1[i]*h1[i]*h1p/St1/Bo;
		  B4 = A4 + h1[i]*h1[i]*h1[i]/3.0/St1/Bo;

		  gsl_matrix_set(A, i, i-1, -1.0/2.0/dr*A1+1.0/dr2*A2+1.0/dr3*A3-4.0/dr4*A4);
		  gsl_matrix_set(A, i, i, -1.0/dt-2.0/dr2*A2-1.0/2.0/dr3*A3+7.0/dr4*A4);
		  gsl_matrix_set(A, i, i+1, 1.0/2.0/dr*A1+1.0/dr2*A2-1.0/dr3*A3-4.0/dr4*A4);
		  gsl_matrix_set(A, i, i+2, 1.0/2.0/dr3*A3+1.0/dr4*A4);

		  gsl_matrix_set(A, i, jH-1, -1.0/2.0/dr*B1+1.0/dr2*B2+1.0/dr3*B3-4.0/dr4*B4);
		  gsl_matrix_set(A, i, jH, -2.0/dr2*B2-1.0/2.0/dr3*B3+7.0/dr4*B4);
		  gsl_matrix_set(A, i, jH+1, 1.0/2.0/dr*B1+1.0/dr2*B2-1.0/dr3*B3-4.0/dr4*B4);
		  gsl_matrix_set(A, i, jH+2, 1.0/2.0/dr3*B3+1.0/dr4*B4);

		  gsl_vector_set(B, i, -h1[i]/dt);
	  }
	  else if (i==n-1){
		  gsl_matrix_set(A, i, i-1, -2.0);
		  gsl_matrix_set(A, i, i, 2 + 2*dr*sqrt(Bo) + dr2*Bo);

		  gsl_vector_set(B, i, h0 * (2*dr*sqrt(Bo) + dr2*Bo));

	  }
	  else if (i==n-2){
		  h1p = (h1[i+1]-h1[i-1])/2.0/dr;
		  hp = (H[i+1]-H[i-1])/2.0/dr;
		  A1 = -h1[i]*h1[i]*h1p/St1 - h1[i]*h1p*H[i]/St1 - h1[i]*h1[i]*hp/2.0/St1;
		  A2 = -h1[i]*h1[i]/St1 * (h1[i]/3.0+H[i]/2.0);
		  A3 = -2.0*h1[i]*h1[i]*h1p/St1/Bo - h1[i]*h1p*H[i]/St1/Bo - h1[i]*h1[i]*hp/2.0/St1/Bo;
		  A4 = -h1[i]*h1[i]/St1/Bo * (2.0*h1[i]/3.0+H[i]/2.0);
		  B1 = A1;
		  B2 = A2;
		  B3 = A3 + h1[i]*h1[i]*h1p/St1/Bo;
		  B4 = A4 + h1[i]*h1[i]*h1[i]/3.0/St1/Bo;

		  gsl_matrix_set(A, i, i-2, -1.0/2.0/dr3*A3+1.0/dr4*A4);
		  gsl_matrix_set(A, i, i-1, -1.0/2.0/dr*A1+1.0/dr2*A2+1.0/dr3*A3-4.0/dr4*A4);
		  gsl_matrix_set(A, i, i, -1.0/dt-2.0/dr2*A2+1.0/2.0/dr3*A3+7.0/dr4*A4);
		  gsl_matrix_set(A, i, i+1, 1.0/2.0/dr*A1+1.0/dr2*A2-1.0/dr3*(1+dr*sqrt(Bo))*A3-1.0/dr4*(4+2.0*dr*sqrt(Bo))*A4
				  +1.0/dr2*sqrt(Bo)*B3 + 2.0/dr3*sqrt(Bo)*B4);

		  gsl_matrix_set(A, i, jH-2, -1.0/2.0/dr3*B3+1.0/dr4*B4);
		  gsl_matrix_set(A, i, jH-1, -1.0/2.0/dr*B1+1.0/dr2*B2+1.0/dr3*B3-4.0/dr4*B4);
		  gsl_matrix_set(A, i, jH, -2.0/dr2*B2+1.0/2.0/dr3*B3+7.0/dr4*B4);
		  gsl_matrix_set(A, i, jH+1, 1.0/2.0/dr*B1+1.0/dr2*B2-1.0/dr3*B3-4.0/dr4*B4);

		  gsl_vector_set(B, i, -h1[i]/dt - sqrt(Bo)*h0/dr2*A3 - 2.0*sqrt(Bo)*h0/dr3*A4
				  -B3*(Hp/dr2-sqrt(Bo)*h0/dr2) - B4*(2.0*Hp/dr3-2.0*sqrt(Bo)*h0/dr3));

	  }
	  else{
		  h1p = (h1[i+1]-h1[i-1])/2.0/dr;
		  hp = (H[i+1]-H[i-1])/2.0/dr;
		  A1 = -h1[i]*h1[i]*h1p/St1 - h1[i]*h1p*H[i]/St1 - h1[i]*h1[i]*hp/2.0/St1;
		  A2 = -h1[i]*h1[i]/St1 * (h1[i]/3.0+H[i]/2.0);
		  A3 = -2.0*h1[i]*h1[i]*h1p/St1/Bo - h1[i]*h1p*H[i]/St1/Bo - h1[i]*h1[i]*hp/2.0/St1/Bo;
		  A4 = -h1[i]*h1[i]/St1/Bo * (2.0*h1[i]/3.0+H[i]/2.0);
		  B1 = A1;
		  B2 = A2;
		  B3 = A3 + h1[i]*h1[i]*h1p/St1/Bo;
		  B4 = A4 + h1[i]*h1[i]*h1[i]/3.0/St1/Bo;

		  gsl_matrix_set(A, i, i-2, -1.0/2.0/dr3*A3+1.0/dr4*A4);
		  gsl_matrix_set(A, i, i-1, -1.0/2.0/dr*A1+1.0/dr2*A2+1.0/dr3*A3-4.0/dr4*A4);
		  gsl_matrix_set(A, i, i, -1.0/dt-2.0/dr2*A2+6.0/dr4*A4);
		  gsl_matrix_set(A, i, i+1, 1.0/2.0/dr*A1+1.0/dr2*A2-1.0/dr3*A3-4.0/dr4*A4);
		  gsl_matrix_set(A, i, i+2, 1.0/2.0/dr3*A3+1.0/dr4*A4);

		  gsl_matrix_set(A, i, jH-2, -1.0/2.0/dr3*B3+1.0/dr4*B4);
		  gsl_matrix_set(A, i, jH-1, -1.0/2.0/dr*B1+1.0/dr2*B2+1.0/dr3*B3-4.0/dr4*B4);
		  gsl_matrix_set(A, i, jH, -2.0/dr2*B2+6.0/dr4*B4);
		  gsl_matrix_set(A, i, jH+1, 1.0/2.0/dr*B1+1.0/dr2*B2-1.0/dr3*B3-4.0/dr4*B4);
		  gsl_matrix_set(A, i, jH+2, 1.0/2.0/dr3*B3+1.0/dr4*B4);

		  gsl_vector_set(B, i, -h1[i]/dt);
	  }
/******************************************************************/
}
/******************************************************************/
  for (i=0;i<=n-1;i++){
/******************************************************************/
	  jH = i+n;
/******************************************************************/
	  /* H = h2-h1 */
/******************************************************************/
	  if (i==0){
		  h1p = 0;
		  hp = 0;
		  A1 = -H[i]*H[i]*hp/St2 - h1[i]*h1p*H[i]/St1 - h1[i]*h1[i]*hp/2.0/St1 - h1p*H[i]*H[i]/St1 -2.0*h1[i]*H[i]*hp/St1;
		  A2 = -H[i]*H[i]*H[i]/3.0/St2 - h1[i]*h1[i]*H[i]/2.0/St1 - h1[i]*H[i]*H[i]/St1;
		  A3 = -H[i]*H[i]*hp/St2/Bo - 2.0*h1[i]*h1p*H[i]/St1/Bo - h1[i]*h1[i]*hp/St1/Bo - h1p*H[i]*H[i]/St1/Bo - 2.0*h1[i]*H[i]*hp/St1/Bo; 
		  A4 = -H[i]*H[i]*H[i]/3.0/St2/Bo - h1[i]*h1[i]*H[i]/St1/Bo - h1[i]*H[i]*H[i]/St1/Bo; 
		  B1 = A1;
		  B2 = A2;
		  B3 = A3 + h1[i]*h1p*H[i]/St1/Bo + h1[i]*h1[i]*hp/2.0/St1/Bo;
		  B4 = A4 + h1[i]*h1[i]*H[i]/2.0/St1/Bo;

		  gsl_matrix_set(A, jH, i, -2.0/dr2*A2+6.0/dr4*A4);
		  gsl_matrix_set(A, jH, i+1, 2.0/dr2*A2-8.0/dr4*A4);
		  gsl_matrix_set(A, jH, i+2, 2.0/dr4*A4);

		  gsl_matrix_set(A, jH, jH, -1.0/dt-2.0/dr2*B2+6.0/dr4*B4);
		  gsl_matrix_set(A, jH, jH+1, 2.0/dr2*B2-8.0/dr4*B4);
		  gsl_matrix_set(A, jH, jH+2, 2.0/dr4*B4);

		  gsl_vector_set(B, jH, -H[i]/dt);
	  }
	  else if (i==1){
		  h1p = (h1[i+1]-h1[i-1])/2.0/dr;
		  hp = (H[i+1]-H[i-1])/2.0/dr;
		  A1 = -H[i]*H[i]*hp/St2 - h1[i]*h1p*H[i]/St1 - h1[i]*h1[i]*hp/2.0/St1 - h1p*H[i]*H[i]/St1 -2.0*h1[i]*H[i]*hp/St1;
		  A2 = -H[i]*H[i]*H[i]/3.0/St2 - h1[i]*h1[i]*H[i]/2.0/St1 - h1[i]*H[i]*H[i]/St1;
		  A3 = -H[i]*H[i]*hp/St2/Bo - 2.0*h1[i]*h1p*H[i]/St1/Bo - h1[i]*h1[i]*hp/St1/Bo - h1p*H[i]*H[i]/St1/Bo - 2.0*h1[i]*H[i]*hp/St1/Bo; 
		  A4 = -H[i]*H[i]*H[i]/3.0/St2/Bo - h1[i]*h1[i]*H[i]/St1/Bo - h1[i]*H[i]*H[i]/St1/Bo; 
		  B1 = A1;
		  B2 = A2;
		  B3 = A3 + h1[i]*h1p*H[i]/St1/Bo + h1[i]*h1[i]*hp/2.0/St1/Bo;
		  B4 = A4 + h1[i]*h1[i]*H[i]/2.0/St1/Bo;

		  gsl_matrix_set(A, jH, i-1, -1.0/2.0/dr*A1+1.0/dr2*A2+1.0/dr3*A3-4.0/dr4*A4);
		  gsl_matrix_set(A, jH, i, -2.0/dr2*A2-1.0/2.0/dr3*A3+7.0/dr4*A4);
		  gsl_matrix_set(A, jH, i+1, 1.0/2.0/dr*A1+1.0/dr2*A2-1.0/dr3*A3-4.0/dr4*A4);
		  gsl_matrix_set(A, jH, i+2, 1.0/2.0/dr3*A3+1.0/dr4*A4);

		  gsl_matrix_set(A, jH, jH-1, -1.0/2.0/dr*B1+1.0/dr2*B2+1.0/dr3*B3-4.0/dr4*B4);
		  gsl_matrix_set(A, jH, jH, -1.0/dt-2.0/dr2*B2-1.0/2.0/dr3*B3+7.0/dr4*B4);
		  gsl_matrix_set(A, jH, jH+1, 1.0/2.0/dr*B1+1.0/dr2*B2-1.0/dr3*B3-4.0/dr4*B4);
		  gsl_matrix_set(A, jH, jH+2, 1.0/2.0/dr3*B3+1.0/dr4*B4);

		  gsl_vector_set(B, jH, -H[i]/dt);
	  }
	  else if (i==n-1){
		  	gsl_matrix_set(A, jH, 0, -dr/2.0);
		  	gsl_matrix_set(A, jH, n, -dr/2.0);
		  for (j=1;j<=n-3;j++){
		  	gsl_matrix_set(A, jH, j, -dr);
		  	gsl_matrix_set(A, jH, j+n, -dr);
		  }
		  	gsl_matrix_set(A, jH, n-2, -dr + 2.0/Bo/dr2);
		  	gsl_matrix_set(A, jH, 2*n-2, -dr + 2.0/Bo/dr2);

		  	gsl_matrix_set(A, jH, n-1, 1 - dr/2.0 - 2.0/Bo/dr2);
		  	gsl_matrix_set(A, jH, 2*n-1, 1 - dr/2.0 - 2.0/Bo/dr2);
                                      
		  gsl_vector_set(B, jH, S + Hp*(1-2.0/dr)/Bo);
		  /*gsl_vector_set(B, jH, 7.5534 + Hp*(1-2.0/dr)/Bo);*/
	  }
	  else if (i==n-2){
		  h1p = (h1[i+1]-h1[i-1])/2.0/dr;
		  hp = (H[i+1]-H[i-1])/2.0/dr;
		  A1 = -H[i]*H[i]*hp/St2 - h1[i]*h1p*H[i]/St1 - h1[i]*h1[i]*hp/2.0/St1 - h1p*H[i]*H[i]/St1 -2.0*h1[i]*H[i]*hp/St1;
		  A2 = -H[i]*H[i]*H[i]/3.0/St2 - h1[i]*h1[i]*H[i]/2.0/St1 - h1[i]*H[i]*H[i]/St1;
		  A3 = -H[i]*H[i]*hp/St2/Bo - 2.0*h1[i]*h1p*H[i]/St1/Bo - h1[i]*h1[i]*hp/St1/Bo - h1p*H[i]*H[i]/St1/Bo - 2.0*h1[i]*H[i]*hp/St1/Bo; 
		  A4 = -H[i]*H[i]*H[i]/3.0/St2/Bo - h1[i]*h1[i]*H[i]/St1/Bo - h1[i]*H[i]*H[i]/St1/Bo; 
		  B1 = A1;
		  B2 = A2;
		  B3 = A3 + h1[i]*h1p*H[i]/St1/Bo + h1[i]*h1[i]*hp/2.0/St1/Bo;
		  B4 = A4 + h1[i]*h1[i]*H[i]/2.0/St1/Bo;

		  gsl_matrix_set(A, jH, i-2, -1.0/2.0/dr3*A3+1.0/dr4*A4);
		  gsl_matrix_set(A, jH, i-1, -1.0/2.0/dr*A1+1.0/dr2*A2+1.0/dr3*A3-4.0/dr4*A4);
		  gsl_matrix_set(A, jH, i, -2.0/dr2*A2+1.0/2.0/dr3*A3+7.0/dr4*A4);
		  gsl_matrix_set(A, jH, i+1, 1.0/2.0/dr*A1+1.0/dr2*A2-1.0/dr3*(1+dr*sqrt(Bo))*A3-1.0/dr4*(4+2.0*dr*sqrt(Bo))*A4
				  +1.0/dr2*sqrt(Bo)*B3 + 2.0/dr3*sqrt(Bo)*B4);

		  gsl_matrix_set(A, jH, jH-2, -1.0/2.0/dr3*B3+1.0/dr4*B4);
		  gsl_matrix_set(A, jH, jH-1, -1.0/2.0/dr*B1+1.0/dr2*B2+1.0/dr3*B3-4.0/dr4*B4);
		  gsl_matrix_set(A, jH, jH, -1.0/dt-2.0/dr2*B2+1.0/2.0/dr3*B3+7.0/dr4*B4);
		  gsl_matrix_set(A, jH, jH+1, 1.0/2.0/dr*B1+1.0/dr2*B2-1.0/dr3*B3-4.0/dr4*B4);

		  gsl_vector_set(B, jH, -H[i]/dt - sqrt(Bo)*h0/dr2*A3 - 2.0*sqrt(Bo)*h0/dr3*A4
				  -B3*(Hp/dr2-sqrt(Bo)*h0/dr2) - B4*(2.0*Hp/dr3-2.0*sqrt(Bo)*h0/dr3));
	  }
	  else{
		  h1p = (h1[i+1]-h1[i-1])/2.0/dr;
		  hp = (H[i+1]-H[i-1])/2.0/dr;
		  A1 = -H[i]*H[i]*hp/St2 - h1[i]*h1p*H[i]/St1 - h1[i]*h1[i]*hp/2.0/St1 - h1p*H[i]*H[i]/St1 -2.0*h1[i]*H[i]*hp/St1;
		  A2 = -H[i]*H[i]*H[i]/3.0/St2 - h1[i]*h1[i]*H[i]/2.0/St1 - h1[i]*H[i]*H[i]/St1;
		  A3 = -H[i]*H[i]*hp/St2/Bo - 2.0*h1[i]*h1p*H[i]/St1/Bo - h1[i]*h1[i]*hp/St1/Bo - h1p*H[i]*H[i]/St1/Bo - 2.0*h1[i]*H[i]*hp/St1/Bo; 
		  A4 = -H[i]*H[i]*H[i]/3.0/St2/Bo - h1[i]*h1[i]*H[i]/St1/Bo - h1[i]*H[i]*H[i]/St1/Bo; 
		  B1 = A1;
		  B2 = A2;
		  B3 = A3 + h1[i]*h1p*H[i]/St1/Bo + h1[i]*h1[i]*hp/2.0/St1/Bo;
		  B4 = A4 + h1[i]*h1[i]*H[i]/2.0/St1/Bo;

		  gsl_matrix_set(A, jH, i-2, -1.0/2.0/dr3*A3+1.0/dr4*A4);
		  gsl_matrix_set(A, jH, i-1, -1.0/2.0/dr*A1+1.0/dr2*A2+1.0/dr3*A3-4.0/dr4*A4);
		  gsl_matrix_set(A, jH, i, -2.0/dr2*A2+6.0/dr4*A4);
		  gsl_matrix_set(A, jH, i+1, 1.0/2.0/dr*A1+1.0/dr2*A2-1.0/dr3*A3-4.0/dr4*A4);
		  gsl_matrix_set(A, jH, i+2, 1.0/2.0/dr3*A3+1.0/dr4*A4);

		  gsl_matrix_set(A, jH, jH-2, -1.0/2.0/dr3*B3+1.0/dr4*B4);
		  gsl_matrix_set(A, jH, jH-1, -1.0/2.0/dr*B1+1.0/dr2*B2+1.0/dr3*B3-4.0/dr4*B4);
		  gsl_matrix_set(A, jH, jH, -1.0/dt-2.0/dr2*B2+6.0/dr4*B4);
		  gsl_matrix_set(A, jH, jH+1, 1.0/2.0/dr*B1+1.0/dr2*B2-1.0/dr3*B3-4.0/dr4*B4);
		  gsl_matrix_set(A, jH, jH+2, 1.0/2.0/dr3*B3+1.0/dr4*B4);

		  gsl_vector_set(B, jH, -H[i]/dt);
	  }
/******************************************************************/
}

  gsl_linalg_LU_decomp(A, per, &signum);
  /*fprintf(stderr,"\nDet = %g\n", gsl_linalg_LU_det(A,signum));*/

  gsl_linalg_LU_svx(A, per, B);

	for (i=0; i<=n-1; i++){
		h1[i] = gsl_vector_get(B,i);
		H[i] = gsl_vector_get(B,i+n);
		/*printf("%g %g %g\n",r[i],h1[i],h1[i]+H[i]);*/
	}
/*exit(1);*/

#if 0
/* COMPUTE THE PRESSURE */
	for (i=0; i<=n-1; i++){
		if (i==0){
			him1 = h1[1]+H[1];
			hi = h1[i]+H[i];
			hip1 = h1[i+1]+H[i+1];
			d2hdr2 = (him1-2.0*hi+hip1)/dr2;
			pressure[i] = -hi-d2hdr2/Bo;
		}
		else if (i==n-1){
			him1 = h1[i-1]+H[i-1];
			hi = h1[i]+H[i];
			hip1 = h1[i-1]+2*dr*Hp+H[i-1];
			d2hdr2 = (him1-2.0*hi+hip1)/dr2;
			pressure[i] = -hi-d2hdr2/Bo;
		}
		else{
			him1 = h1[i-1]+H[i-1];
			hi = h1[i]+H[i];
			hip1 = h1[i+1]+H[i+1];
			d2hdr2 = (him1-2.0*hi+hip1)/dr2;
			pressure[i] = -hi-d2hdr2/Bo;
		}
	}
	for (i=0; i<=n-1; i++){
			  pressure[i] -= pressure[n-1];
	}

/* COMPUTE THE PRESSURE */
#endif

	/*exit(1);*/
#if 0
  	printf("set style fill transparent solid 0.2 border lc rgb 'blue'\n");

          /*printf("set size square -1\n");*/
  	printf("set size ratio 0.5\n");
  	printf("set style fill solid 0.3 border lc rgb 'gray10'\n");
	  printf("plot [%g:%g][0:1] '-' u 1:2 w filledcurves above y1=-10 lt 1 lc rgb 'blue' lw 2 t '', '-' u 1:2 w filledcurves below y1=10 lt 1 lc rgb 'blue' lw 2 t '', '-' u 1:2 w l lt 1 lc rgb 'red' lw 2 t '', '-' u 1:2 w l lt 1 lc rgb 'green' lw 2 t ''\n",-1.0,1.0);
	for (i=n-1; i>=1; i--){
		printf("%.20g %.20g\n",-r[i],h1[i]);
	}
	for (i=0; i<=n-1; i++){
		printf("%.20g %.20g\n",r[i],h1[i]);
	}
  	printf("e\n");
	printf("\n");
	for (i=n-1; i>=1; i--){
		printf("%.20g %.20g\n",-r[i],h1[i]+H[i]);
	}
	for (i=0; i<=n-1; i++){
		printf("%.20g %.20g\n",r[i],h1[i]+H[i]);
	}
	  printf("e\n");
	printf("\n");
	for (i=n-1; i>=1; i--){
		printf("%.20g %.20g\n",-r[i],H[i]*10);
	}
	for (i=0; i<=n-1; i++){
		printf("%.20g %.20g\n",r[i],H[i]*10);
	}
	  printf("e\n");
	printf("\n");
	for (i=n-1; i>=1; i--){
		printf("%.20g %.20g\n",-r[i],pressure[i]/50.0);
	}
	for (i=0; i<=n-1; i++){
		printf("%.20g %.20g\n",r[i],pressure[i]/50.0);
	}
	  printf("e\n");
	printf("\n");
#endif
/******************************************************************/
	gsl_matrix_free(A);
	gsl_vector_free(B);
	gsl_permutation_free(per);

	return 1;

	}


