#include "utilf.h"
#include "global.h"
#include <stdio.h>
#include "time_step.h"
#include "interpolation.h"
#include "markers.h"
#include "ini_conditions.h"

/**
This function computes the right-hand side of the evolution equation for h1
*/
void dh1dt(Surface surf, double * u, double * v, double * p2, PhysStruct *phys, NumStruct *num, double *h1, double *kappa1, double *dh1dt)
{
	int nd = surf->sx->n;
	int i=nd-1, n=num->n_film;
	int n_rim,ne;
	int j=1;
	double dx = phys->r_film/(double)(num->n_film-1);
	double *h2, *u2, *v2, *dh2dt, *dp2dr;
	double r = dx;
	double *lhs;
	double tmp1, tmp2;
	double Bo,St1,St2;
	double p1m1,p1p1,*f,*fp,*g,*gp;
	double xstep;

	/****************************************/ 
	Bo = phys->Bo;
	St1 = phys->St1;
	St2 = phys->St2;
	/****************************************/ 

	h2 = (double *)calloc(n,n*sizeof(double));
	u2 = (double *)calloc(n,n*sizeof(double));
	v2 = (double *)calloc(n,n*sizeof(double));
	dh2dt = (double *)calloc(n,n*sizeof(double));
	lhs = (double *)calloc(n,n*sizeof(double));
	dp2dr = (double *)calloc(n,n*sizeof(double));
	f = (double *)calloc(n,n*sizeof(double));
	fp = (double *)calloc(n,n*sizeof(double));
	g = (double *)calloc(n,n*sizeof(double));
	gp = (double *)calloc(n,n*sizeof(double));

	/*for (i=nd-1;i>=0;i--){*/
		/*printf("%d %g\n", nd-1-i,v[i]);*/
	/*}*/
	/*exit(1);*/

	/*for (i=nd-1;i>=0;i--){*/
		/*printf("%.20g %.20g\n", surf->sx->x[i],u[i]);*/
	/*}*/
	/*printf("\n");*/
	for (i=0;i<=n-1;i++){
		h2[i] = 100.0;
		p2[i] = 0.0;
	}

	i = nd-1;
	while (surf->sx->x[i-1]>=surf->sx->x[i]) i--;
	i++;
	n_rim = i;

	h2[0] = surf->sy->x[nd-1];
	u2[0] = u[nd-1];
	v2[0] = v[nd-1];
		/*printf("%.20g %.20g\n",0.0,u2[0]);*/

	i = nd-1;
	while (r<=surf->sx->x[n_rim]){
		while (surf->sx->x[i]<=r) i--;
		i++;
		h2[j] = surf->sy->x[i] + (surf->sy->x[i-1]-surf->sy->x[i]) * (r-surf->sx->x[i]) / (surf->sx->x[i-1]-surf->sx->x[i]);
		u2[j] = u[i] + (u[i-1]-u[i]) * (r-surf->sx->x[i]) / (surf->sx->x[i-1]-surf->sx->x[i]);
		v2[j] = v[i] + (v[i-1]-v[i]) * (r-surf->sx->x[i]) / (surf->sx->x[i-1]-surf->sx->x[i]);
		/*printf("%.20g %.20g\n",r,h2[j]);*/
		j++;
		r += dx;
	}

	ne = j-1;
	/*i=ne-20;*/
		/*printf("\n%.20g %.20g\n",0.0,(h2[i+1]-h2[i-1])/2.0/dx);*/
		/*exit(1);*/

	/* Calcul de dh2/dt */
		dh2dt[0] = v2[0];
	for (i=1;i<=ne-2;i++){
		dh2dt[i] = v2[i]-u2[i]*(h2[i+1]-h2[i-1])/2.0/dx;
	}
		dh2dt[ne-1] = v2[ne-1];

	/* Calcul de lhs = 1/r * \int_0^r {r' dh2/dt dr'} */


	lhs[0] = 0;
	r = dx;
	lhs[1] = dh2dt[0]*r/2. + (dh2dt[1]-dh2dt[0])*r/3.;
	r += dx;
	for (i=2;i<=ne-1;i++){
		lhs[i] = ( lhs[i-1]*(r-dx) + 0.5*dx*((r-dx)*dh2dt[i-1]+r*dh2dt[i]) ) /r;
		r += dx;
	}

	/*printf("plot [][] '-' t 'dp2/dr','' t 'lhs', '' t 'p2', '' t 'f'\n");*/
	for (i=0;i<=ne-1;i++){
		dp2dr[i] = lhs[i] + kappa1[i]/Bo * 
			(
			 h1[i]*h1[i]*h1[i]/3./St1
			 + h1[i]*h1[i]*(h2[i]-h1[i])/2./St1
			 );
		tmp1 = h1[i]*h1[i]*h1[i]/3./St1 
			+ (h2[i]-h1[i])*(h2[i]-h1[i])*(h2[i]-h1[i])/3./St2
			+ h1[i]*(h2[i]-h1[i])*(2*h2[i]-h1[i])/2./St1
			+ h1[i]*h1[i]*(h2[i]-h1[i])/2./St1;
		dp2dr[i] /= tmp1;

		/*xstep = (double)( ne-1 - i ) / (double)((ne-1)-(ne-50));*/
		/*dp2dr[i] *= smooth_step(xstep);*/

		/*printf("%.20g %.20g\n",i*dx,dp2dr[i]);*/
	}
	/*printf("e\n");*/
	/*exit(1);*/
	/*for (i=0;i<=n-1;i++){*/
		/*printf("%.20g %.20g\n",i*dx,lhs[i]);*/
	/*}*/
	/*printf("e\n");*/

	p2[0] = 0.0;
	for (i=1;i<=ne-1;i++){
		p2[i] = p2[i-1] + 0.5*dx*(dp2dr[i]+dp2dr[i-1]);
	}

	/*printf("plot [][] '-' t 'p2-p2_smoothed'\n");*/
	/*printf("plot [0.97:1][] '-' w lp pt 6 t 'p2', '' w lp pt 7 t 'p2 smoothed'\n");*/
	for (i=0;i<=ne-1;i++){
		p2[i] -= p2[ne-1];
	}
	/*for (i=0;i<=n-1;i++){*/
		/*printf("%.20g %.20g\n",i*dx,p2[i]);*/
	/*}*/
	/*printf("e\n");*/
	/*exit(1);*/
#if 0
	for (i=0;i<=ne-1;i++){
		xstep = (( ne-1 - i ) / 9.0);
		/*xstep = ( (ne-1) - i ) / ( (ne-1) - (ne-10) );*/
		/*printf("%.20g %.20g\n",i*dx,p2[i]*(1-smooth_step(xstep)));*/
		p2[i] *= smooth_step(xstep);
		/*printf("%.20g %.20g\n",i*dx,xstep);*/
		/*printf("%.20g %.20g\n",i*dx,p2[i]);*/
	}
	/*printf("e\n");*/
#endif

	/*printf("plot [][] '-' t 'f', '' t 'dh1dt'\n");*/
	f[0] = 0.0;
		/*printf("%.20g %.20g\n",0,0);*/
	for (i=1;i<=ne-2;i++){
		f[i] =  ( 
				h1[i]*h1[i]*h1[i]/3. 
				+ h1[i]*h1[i]*(h2[i]-h1[i])/2.
				) 
			* dp2dr[i];
	}
	i=ne-1;
		f[i] =  ( 
				h1[i]*h1[i]*h1[i]/3. 
				+ h1[i]*h1[i]*(h2[i]-h1[i])/2.
				) 
			* dp2dr[i];

	g[0] = 0.0;
	for (i=1;i<=n-2;i++){
		g[i] = - h1[i]*h1[i]*h1[i]/3./Bo*(kappa1[i+1]-kappa1[i-1])/2./dx;
	}
	i=n-1;
		g[i] = - h1[i]*h1[i]*h1[i]/3./Bo*(kappa1[i]-kappa1[i-1])/dx;

	for (i=0;i<=ne-1;i++){
		if (i==0){
			fp[i] = 2*(f[i+1]-f[i])/dx;
		}
		else if (i==ne-1){
			fp[i] = (f[i]-f[i-1])/dx + f[i] / (i*dx);
		}
		else{
			fp[i] = (f[i+1]-f[i-1])/2./dx + f[i] / (i*dx);
		}
	}

	for (i=0;i<=n-1;i++){
		if (i==0){
			gp[i] = 2*(g[i+1]-g[i])/dx;
		}
		else if (i==n-1){
			gp[i] = (g[i]-g[i-1])/dx + g[i] / (i*dx);
		}
		else{
			gp[i] = (g[i+1]-g[i-1])/2./dx + g[i] / (i*dx);
		}
	}

	for (i=0;i<=n-1;i++){
		dh1dt[i] = gp[i] / St1;
	}

	for (i=0;i<=ne-1;i++){
		dh1dt[i] += fp[i] / St1;
		xstep = (double)( ne-1 - i ) / (double)((ne-1)-(ne-10));
		dh1dt[i] *= smooth_step(xstep);
		/*dh1dt[i] = 0.0;*/
	}
#if 0
	printf("plot [-1:1][0:0.1] '-' ls 1 lw 2 lc '#6BC4FF' t 'h2-h1'\n");
	for (i=n-1;i>=1;i--){
		/*printf("%.20g %.20g\n",-i*dx,h2[i]-h1[i]);*/
		printf("%.20g %.20g %.20g %.20g\n",-i*dx,h2[i]-h1[i],h1[i],h2[i]);
	}
	for (i=0;i<=n-1;i++){
		/*printf("%.20g %.20g\n",i*dx,h2[i]-h1[i]);*/
		printf("%.20g %.20g %.20g %.20g\n",i*dx,h2[i]-h1[i],h1[i],h2[i]);
	}
	printf("e\n");

	/*exit(1);*/
#endif
	free(h2);
	free(u2);
	free(v2);
	free(dh2dt);
	free(f);
	free(fp);
	free(g);
	free(gp);


}
