#include "utilf.h"
#include "global.h"
#include "markers.h"
#include "ini_conditions.h"
#include <time.h>
#include "integral.h"
#include "phi_moy.h"
#include "time_step.h"
#include <time.h>
#include <glib.h>

void comp_p(double *r, double *h1, double *H, double h0, double Hp, int n, double Bo, double *p1, double *p2)
{
	int i; 
	double dr = r[1]-r[0];
	double dr2=dr*dr;
	double hi,him1,hip1,d2hdr2;

/********** P2 **********/	
	for (i=0; i<=n-1; i++){
		if (i==0){
			him1 = h1[1]+H[1];
			hi = h1[i]+H[i];
			hip1 = h1[i+1]+H[i+1];
			d2hdr2 = (him1-2.0*hi+hip1)/dr2;
			p2[i] = -hi-d2hdr2/Bo;
		}
		else if (i==n-1){
			him1 = h1[i-1]+H[i-1];
			hi = h1[i]+H[i];
			hip1 = h1[i-1] + 2*dr*Hp + H[i-1];
			d2hdr2 = (him1-2.0*hi+hip1)/dr2;
			p2[i] = -hi-d2hdr2/Bo;
		}
		else{
			him1 = h1[i-1]+H[i-1];
			hi = h1[i]+H[i];
			hip1 = h1[i+1]+H[i+1];
			d2hdr2 = (him1-2.0*hi+hip1)/dr2;
			p2[i] = -hi-d2hdr2/Bo;
		}
	}
	for (i=0; i<=n-1; i++){
			  p2[i] -= p2[n-1];
	}
/********** P1 **********/	
	for (i=0; i<=n-1; i++){
		if (i==0){
			him1 = h1[1];
			hi = h1[i];
			hip1 = h1[i+1];
			d2hdr2 = (him1-2.0*hi+hip1)/dr2;
			p1[i] = p2[i]-d2hdr2/Bo;
		}
		else if (i==n-1){
			him1 = h1[i-1];
			hi = h1[i];
			hip1 = h1[i-1] - 2*dr*sqrt(Bo)*(h1[i]-h0);
			d2hdr2 = (him1-2.0*hi+hip1)/dr2;
			p1[i] = p2[i]-d2hdr2/Bo;
		}
		else{
			him1 = h1[i-1];
			hi = h1[i];
			hip1 = h1[i+1];
			d2hdr2 = (him1-2.0*hi+hip1)/dr2;
			p1[i] = p2[i]-d2hdr2/Bo;
		}
	}

}
