#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#define OUT 0

int main(int argc, char *argv[])
{
	int i, n, end;
	double Bo;
	double *psi, *r, *z, *zo;
	double dpsi, dr;
	double a, vol = 0;
	double surf = 0.0;
	const double PI=4.0 * atan(1.0);
	double L,R;
	double Rmax = 0.0;
	double Rvol;
	double lc;
	double R0;
	double pmax = 1.0;
	double rho3 = 870;
	double gamma = 17e-3;
	double g = 9.81;
	double eta1 = 1e-4 * 870;
	double eta2 = 18e-6;
	double h0 = 30e-6;

	/*h0 = 60e-6;*/
	/*eta1 = 10000;*/

	if (argc != 4) {
		fprintf(stderr, "Usage: %s n R0 lc\n", argv[0]);
		exit(1);
	}

	n = atoi(argv[1]);
	R0 = atof(argv[2]);
	lc = atof(argv[3]);

	r = (double *)malloc(n * sizeof(double));
	z = (double *)malloc(n * sizeof(double));
	zo = (double *)malloc(n * sizeof(double));
	psi = (double *)malloc(n * sizeof(double));

	for (i=0;i<=n-1;i++){
		psi[i] = PI - (double)i/(double)(n-1)*PI;
	}

	dpsi = -1.0/(double)(n-1)*PI;

	/* R0 est le rayon de courbure au sommet de la goutte */
	Bo = R0*R0/lc/lc;

	/* The shape only depends on Bo (not on lc) */
	r[0] = 0.0;
	z[0] = 0.0;

	r[1] =  -sin(dpsi);
	z[1] = -1 + cos(dpsi);

	for (i=2;i<=n-1;i++){
		r[i] = r[i-1] - dpsi * cos(psi[i-1]) / (Bo*z[i-1]-1.0);
		z[i] = z[i-1] - dpsi * sin(psi[i-1]) / (Bo*z[i-1]-1.0);
	}

	for (i=0;i<=n-1;i++){
		zo[i]=z[i];
	}

	/* Calcul du volume */
	for (i=0;i<=n-2;i++){
		a = (z[i+1]-z[i]);
		vol += -a * (r[i+1]*r[i+1]+r[i]*r[i+1]+r[i]*r[i])/3.0;
	    }
	    vol = PI * vol;
	/*fprintf(stderr,"V = %g mm^3\n",vol*exp(3.*log(R0))*1e9);*/
	fprintf(stderr,"Rd = %g mm\n",R0*exp(1./3.*log(3./4.*vol/PI))*1e3 );
	/* Calcul du volume */
	/* Calcul de la surface */
	for (i=0;i<=n-2;i++){
		a = (z[i+1]-z[i]);
		surf += -a * (r[i]+r[i+1])/2.0;
	    }
	/*fprintf(stderr,"S = %g mm^2\n",surf*R0*R0*1e6);*/
	/* Calcul de la surface */

	    Rvol = exp(log(3.0/4.0/PI*vol)/3.0);

	end = 0;
	for (i=0;i<=n-1;i++){
		if (tan(psi[i])<=0 || tan(psi[i])>=pmax) end++;
		if (Rmax <= r[i]) Rmax = r[i];
	}
	L = r[end];

	/* Rayon où la pente vaut pmax */
	fprintf(stderr,"L is the radius where the slope equals pmax :\n");
	fprintf(stderr,"L = %g mm\n",R0*L*1e3);
	/*fprintf(stderr,"V/L^3 = %g\n",vol/L/L/L);*/
	/*fprintf(stderr,"S/L^2 = %g\n",surf/L/L);*/
	/*fprintf(stderr,"Bond number based on L :\n");*/

	fprintf(stderr,"###########################################\n");
#if 1
	fprintf(stderr,"Bo = %g\n",L*L*R0*R0/lc/lc);
	fprintf(stderr,"h0 = %g\n",h0/(R0*L));
	fprintf(stderr,"St1 = %g\n",eta1/(rho3*L*R0*sqrt(g*L*R0)));
	fprintf(stderr,"St2 = %g\n",eta2/(rho3*L*R0*sqrt(g*L*R0)));
	fprintf(stderr,"Hp = %g\n",tan(psi[end]));
	fprintf(stderr,"S = %g\n",surf/L/L);
#else
	R = L*R0;
	fprintf(stderr,"Bo = %g\n",R*R/lc/lc);
	fprintf(stderr,"h0 = %g\n",h0/R);
	fprintf(stderr,"St1 = %g\n",eta1/(rho3*R*sqrt(g*h0)));
	fprintf(stderr,"St2 = %g\n",eta2/(rho3*R*sqrt(g*h0)));
	fprintf(stderr,"Hp = %g\n",tan(psi[end]));
	fprintf(stderr,"S = %g\n",surf/L/L);
#endif
	fprintf(stderr,"###########################################\n");
#if !OUT
	for (i=0;i<=n-1;i++){
		printf("%g %g\n",r[i]/L,(z[i]-z[n-1])/L);
	}
	exit(1);
#endif
	/* Rayon où la pente vaut pmax */

	for (i=0;i<=n-1;i++){
		r[i] /= L;
		z[i] /= L;
	}
	/*for (i=0;i<=n-1;i++){*/
		/*printf("%g %g\n",r[i],z[i]-z[n-1]);*/
	/*}*/

	/*fprintf(stderr,"Bo1 = %g Bo2 = %g\n",Bo,Bo*exp(2./3.*log(3./4.*vol/PI)));*/

	/*fprintf(stderr,"Bond base on Rmax = %g\n",Bo*Rmax*Rmax);*/
	/*fprintf(stderr,"Bond base on Rvol = %g\n",Bo*Rvol*Rvol);*/
	/*fprintf(stderr,"Bond base on R = %g\n",Bo*L*L);*/

	printf("set style fill transparent solid 1 border lc rgb 'black'\n");
	printf("set size ratio -1\n");
	/*printf("plot [][] '-' w filledcurves y1=-20 ls 1 lw 2 lc '#23A4EA' t ''\n"); */
	/*printf("plot [0:][] '-' w lp ls 1 lw 2 lc '#23A4EA' t '', '-' w p pt 7 ps 3 lc rgbcolor 'black'\n"); */
	printf("plot [][] '-' w lp ls 1 lw 2 lc '#23A4EA' t ''\n"); 

#if 0
	for (i=0;i<=n-1;i++){
		printf("%g %g\n",r[i],z[i]-z[n-1]);
	}
	dr = r[n-1]/20.0;
	for (i=1;i<=20;i++){
		printf("%g %g\n",r[n-1]-dr*i,0.0);
	}
#else
	/*end = 0;*/
	for (i=0;i<=n-1;i++){
		printf("%g %g %g %g\n",r[i],z[i]-z[n-1],tan(psi[i]),(2.0-Bo*zo[i])*exp(1./3.*log(3./4.*vol/PI)));
		/*if (tan(psi[i])<=0 || tan(psi[i])>=0.1) end++;*/
	}
	dr = r[n-1]/20.0;
	for (i=1;i<=20;i++){
		printf("%g %g %g %g\n",r[n-1]-dr*i,0.0,0.0,Bo*z[n-1]-2.0);
	}
	for (i=19;i>=1;i--){
		printf("%g %g %g %g\n",-r[n-1]+dr*i,0.0,0.0,Bo*z[n-1]-2.0);
	}
	for (i=n-1;i>=0;i--){
		printf("%g %g %g %g\n",-r[i],z[i]-z[n-1],tan(psi[i]),(2.0-Bo*zo[i])*exp(1./3.*log(3./4.*vol/PI)));
		/*if (tan(psi[i])<=0 || tan(psi[i])>=0.1) end++;*/
	}
#endif

	printf("e\n");

	return 0;

}
