#include <stdio.h>
#include <stdlib.h>
#include <math.h>
/*#include "utilf.h"*/
/*#include "global.h"*/
/*#include "markers.h"*/
/*#include "ini_conditions.h"*/
/*#include <time.h>*/
/*#include "integral.h"*/
/*#include "phi_moy.h"*/
/*#include "time_step.h"*/
/*#define GP 0*/
/*#include <time.h>*/
/*#include <glib.h>*/


int main(int argc, char *argv[])
{
	int i, n, end;
	double Bo;
	double *psi, *r, *z, *zo;
	double dpsi, dr;
	double a, vol = 0;
	const double PI=4.0 * atan(1.0);

	if (argc != 3) {
		fprintf(stderr, "Usage: %s n Bo\n", argv[0]);
		exit(1);
	}

	n = atoi(argv[1]);
	Bo = atof(argv[2]);

	r = (double *)malloc(n * sizeof(double));
	z = (double *)malloc(n * sizeof(double));
	zo = (double *)malloc(n * sizeof(double));
	psi = (double *)malloc(n * sizeof(double));

	for (i=0;i<=n-1;i++){
		psi[i] = PI - (double)i/(double)(n-1)*PI;
	}

	dpsi = -1.0/(double)(n-1)*PI;


	r[0] = 0.0;
	z[0] = 0.0;

	r[1] =  -sin(dpsi);
	z[1] = -1 + cos(dpsi);

	/*r[1] = r[0] - 2.0 * dpsi * cos(psi[i-1]) / (Bo*z[i-1]-1.0);*/
	/*z[1] = z[0] - 2.0 * dpsi * sin(psi[i-1]) / (Bo*z[i-1]-1.0);*/

	for (i=2;i<=n-1;i++){
		r[i] = r[i-1] - dpsi * r[i-1] * cos(psi[i-1]) / (r[i-1] * (Bo*z[i-1]-2.0)+sin(psi[i-1]) );
		z[i] = z[i-1] - dpsi * r[i-1] * sin(psi[i-1]) / (r[i-1] * (Bo*z[i-1]-2.0)+sin(psi[i-1]) );
	}

	for (i=0;i<=n-1;i++){
		zo[i]=z[i];
	}

	/* Calcul du volume */
	for (i=0;i<=n-2;i++){
		a = (z[i+1]-z[i]);

		/*vol += z[i]*(r[i+1]*r[i+1]-r[i]*r[i])/2.0 + a * ( (r[i+1]*r[i+1]+r[i]*r[i+1]+r[i]*r[i])/3.0 - r[i]*(r[i+1]+r[i])/2.0);*/
		vol += -a * (r[i+1]*r[i+1]+r[i]*r[i+1]+r[i]*r[i])/3.0;
	    }
	    /*vol = 2.0 * PI * vol;*/
	    vol = PI * vol;
	/*fprintf(stderr,"Vol = %g\n",vol);*/
	/*fprintf(stderr,"a = %g\n",exp(1./3.*log(3./4.*vol/PI)));*/
	/* Calcul du volume */

	for (i=0;i<=n-1;i++){
		/*r[i] /= exp(1./3.*log(vol));*/
		/*z[i] /= exp(1./3.*log(vol));*/
		r[i] /= exp(1./3.*log(3./4.*vol/PI));
		z[i] /= exp(1./3.*log(3./4.*vol/PI));
	}

	/*fprintf(stderr,"Bo1 = %g Bo2 = %g\n",Bo,Bo*exp(2./3.*log(3./4.*vol/PI)));*/
	fprintf(stderr,"Bo = %g\n",Bo*exp(2./3.*log(3./4.*vol/PI)));


	printf("set style fill transparent solid 1 border lc rgb 'black'\n");
	printf("set size ratio -1\n");
	/*printf("plot [][] '-' w filledcurves y1=-20 ls 1 lw 2 lc '#23A4EA' t ''\n"); */
	printf("plot [0:][] '-' w lp ls 1 lw 2 lc '#23A4EA' t ''\n"); 

#if 0
	for (i=0;i<=n-1;i++){
		printf("%g %g\n",r[i],z[i]-z[n-1]);
	}
	dr = r[n-1]/20.0;
	for (i=1;i<=20;i++){
		printf("%g %g\n",r[n-1]-dr*i,0.0);
	}
#else
	end = 0;
	for (i=0;i<=n-1;i++){
		printf("%g %g %g %g\n",r[i],z[i]-z[n-1],tan(psi[i]),(2.0-Bo*zo[i])*exp(1./3.*log(3./4.*vol/PI)));
		if (tan(psi[i])<=0 || tan(psi[i])>=0.1) end++;
	}
	dr = r[n-1]/20.0;
	for (i=1;i<=20;i++){
		printf("%g %g %g %g\n",r[n-1]-dr*i,0.0,0.0,Bo*z[n-1]-2.0);
	}
#endif

	printf("e\n");

	vol=0;
	for (i=0;i<=n-2;i++){
		a = (z[i+1]-z[i]);

		/*vol += z[i]*(r[i+1]*r[i+1]-r[i]*r[i])/2.0 + a * ( (r[i+1]*r[i+1]+r[i]*r[i+1]+r[i]*r[i])/3.0 - r[i]*(r[i+1]+r[i])/2.0);*/
		vol += -a * (r[i+1]*r[i+1]+r[i]*r[i+1]+r[i]*r[i])/3.0;
	    }
	    /*vol = 2.0 * PI * vol;*/
	    vol = PI * vol;
	/*fprintf(stderr,"Vol = %g\n",vol);*/
	/*exit(1);*/

	/*fprintf(stderr,"Vol = %g\n",vol);*/
	/*fprintf(stderr,"Bo = %g\n",Bo*exp(2./3.*log(3./4.*vol/PI)));*/
	fprintf(stderr,"R = %g\n",r[end]);
	fprintf(stderr,"Z = %g\n",z[end]-z[n-1]);
	fprintf(stderr,"Hp = %g\n",tan(psi[end]));
	fprintf(stderr,"Hpp = %g\n",(2.0-Bo*zo[end])*exp(1./3.*log(3./4.*vol/PI)));

	return 0;

}
