reset
set terminal push
x=8.6
set terminal epslatex standalone linewidth 2 rounded \
  dashlen 4 color colortext '' 10 size (x)cm,(x*0.284536)cm
set output 'epslatex.tex'
unset autoscale
set encoding iso_8859_1
set nokey

set bmargin .1
set tmargin .1
set lmargin .1
set rmargin .2
Color1='#0065A5'
Color2='#CDD9EB'
#Color1='#A54000'
#Color2='#ebdfcd'
#Color2='#FF8600'
#Color1='#0079FF'
set style fill solid border lc rgb Color1
#set style fill transparent solid 0.3 border lc rgb Color1
#set size ratio -1
unset xtics
unset ytics
set border lc rgb Color1

set arrow from 0,0 to 0,0.284536 front nohead lc rgb Color1
set arrow from 1,0 to 1,0.284536 front nohead lc rgb Color1
set arrow from 0,0.284536 to 1,0.284536 front nohead lc rgb Color1

set arrow from 0.1,0 to 0.1,0.098 front lc rgb Color1
set label '$h_1$' at 0.17,0.05 right front tc rgb Color1

set arrow from 0.3,0 to 0.3,0.12 front lc rgb Color1
set label '$h_2$' at 0.37,0.05 right front tc rgb Color1

set label '$H=h_2-h_1$' at 0.37,0.2 right front tc rgb Color1

h0=0.1
h10 = 0.114202
Bo = 1.0072
f(x) = x>1 ? h0 + (h10-h0)*exp((1-x)*sqrt(Bo)) : 1/0
g(x) = x<-0.95 ? h0 + (h10-h0)*exp((x+1)*sqrt(Bo)) : 1/0

xr=1.7
plot [0:1][0:0.284536] 'drop.txt' u 1:2 with filledcurves below y1=1 lw 2 fc rgb Color2, 'film.txt' u 1:2 with filledcurves y1=0 lt 1 lw 2 lc rgb Color2

#plot [0:1][0:0.284536] 'drop.txt' u 1:2 with filledcurves below y1=1 lw 2 fc rgb Color2, 'film.txt' u 1:2 with filledcurves y1=0 lt 1 lw 2 lc rgb Color2, f(x) w filledcurves above y1=0 lt 1 lw 2 lc rgb Color2, g(x) w filledcurves above y1=0 lt 1 lw 2 lc rgb Color2

#plot [0:1][0:0.284536] 'drop.txt' u 1:2 with filledcurves below y1=1 lw 2 lc rgb "blue", 'film.txt' u 1:2 with filledcurves y1=0 lt 1 lw 2 lc rgb "blue", f(x) w filledcurves above y1=0 lt 1 lw 2 lc rgb 'blue', g(x) w filledcurves above y1=0 lt 1 lw 2 lc rgb 'blue'

#, 'domain.txt' u 1:($2+0.2) w l lt 1 lw 2 lc rgb "red"

    
