reset
set terminal push
x=8.6
No=1.6180339887
set terminal epslatex standalone linewidth 2 rounded \
  dashlen 4 color colortext '' 10 size (x)cm,(x/No)cm
set output 'epslatex.tex'
unset autoscale
set encoding iso_8859_1
set nokey

set bmargin .1
set tmargin .1
set lmargin .1
set rmargin .2

Color='#4292C6'

Color1='#0065A5'
Color2='#CDD9EB'
set style fill solid border lc rgb Color1
#set style fill transparent solid 0.3 border lc rgb Color
#set size ratio -1
unset xtics
unset ytics
set border lc rgb Color1

#set arrow from -1,0 to -1,0.284536 front nohead
set arrow from 0,0 to 0,0.284536 front nohead lc rgb Color1
set arrow from 1,0 to 1,0.284536 front nohead lc rgb Color1
#set arrow from -1,0.284536 to 1,0.284536 front nohead
set arrow from 0,0.284536 to 1,0.284536 front nohead lc rgb Color1

set arrow from 1,0.45 to 1,0.284536 front lc rgb Color1
set label '$R$' at 1.04,0.5 right front tc rgb Color1

set label '$(1)$' at 1.5,0.04 right front tc rgb Color1
set label '$(2)$' at 1.5,0.8 right front tc rgb Color1
set label '$(3)$' at 0,0.8 right front tc rgb Color1

h0=0.1
h10 = 0.114202
Bo = 1.0072
f(x) = x>0.95 ? h0 + (h10-h0)*exp((1-x)*sqrt(Bo)) : 1/0
g(x) = x<-0.95 ? h0 + (h10-h0)*exp((x+1)*sqrt(Bo)) : 1/0

xr=1.7
plot [-xr:xr][0:xr] 'drop.txt' u 1:2 with filledcurves lw 2 lc rgb Color2, 'film.txt' u 1:2 with filledcurves y1=0 lt 1 lw 2 lc rgb Color2, f(x) w filledcurves above y1=0 lt 1 lw 2 lc rgb Color2, g(x) w filledcurves above y1=0 lt 1 lw 2 lc rgb Color2

#, 'domain.txt' u 1:($2+0.2) w l lt 1 lw 2 lc rgb "red"

    
