reset
set terminal push
x=8.6
No=1.6180339887
set terminal epslatex standalone linewidth 2 rounded \
  dashlen 4 color '' 10 size (x)cm,(x/No)cm colortext

set output 'epslatex.tex'
set encoding iso_8859_1

Color1='#0065A5'
Color2='#A54000'
#set format x '$10^{%L}$'
#set format y '$10^{%L}$'
#set xlabel '$t$'
#set ylabel '$H(r,t)$'
unset mxtics
unset mytics
unset key
#set key left top
#f(x) = (x>1e-2 && x<1) ? 0.004*x**(-1./2.) : 1/0
#g(x) = (x>2 && x<100) ? 0.005*x**(-2./3.) : 1/0
#set label 'St$_1=\infty$' at -7,3.6 center front
#set label 'St$_1 \simeq 0.6$' at 7,3.6 center front

file1='L/toto'
file2='S/toto_out'

#set arrow from 0,0 to 0,4 front nohead

j=10
jj=100
k=3600


k1=7
k2=14
k3=28
k4=56
k5=112
k6=224
k7=448
k8=896
k9=1792
k10=3584

s=10
s2=100

set label '$\sim r^2$' at 0.1,1 tc 'red'
set log
plot [1e-2:12][1e-3:100]   file2 every :::k1::k1    u (-($1+10)):($2-0.25) w l lc rgb Color1 t'',\
			file2 every :::k2::k2 u (-($1+10)):($2-0.25) w l lt 1 lc rgb Color1 t '',\
			file2 every :::k3::k3 u (-($1+10)):($2-0.25) w l lt 1 lc rgb Color1 t '',\
			file2 every :::k4::k4 u (-($1+10)):($2-0.25) w l lt 1 lc rgb Color1 t '',\
			file2 every :::k5::k5 u (-($1+10)):($2-0.25) w l lt 1 lc rgb Color1 t '',\
			file2 every :::k6::k6 u (-($1+10)):($2-0.25) w l lt 1 lc rgb Color1 t '',\
			file2 every :::k7::k7 u (-($1+10)):($2-0.25) w l lt 1 lc rgb Color1 t '',\
			file2 every :::k8::k8 u (-($1+10)):($2-0.25) w l lt 1 lc rgb Color1 t '',\
			file2 every :::k9::k9 u (-($1+10)):($2-0.25) w l lt 1 lc rgb Color1 t '',\
			file2 every :::k10::k10 u (-($1+10)):($2-0.25) w l lt 1 lc rgb Color1 t '',\
			x**2 lt 1 lc rgb 'red' t ''
