reset
set terminal push
x=8.6
No=1.6180339887
set terminal epslatex standalone linewidth 2 rounded \
  dashlen 4 color '' 10 size (x)cm,(x/No)cm
set output 'epslatex.tex'
set encoding iso_8859_1

Color1='#0065A5'
Color2='#A54000'
#set format x '$10^{%L}$'
#set format y '$10^{%L}$'
#set xlabel '$t$'
#set ylabel '$H(r,t)$'
unset mxtics
unset mytics
unset key
#set key left top
#f(x) = (x>1e-2 && x<1) ? 0.004*x**(-1./2.) : 1/0
#g(x) = (x>2 && x<100) ? 0.005*x**(-2./3.) : 1/0
set label 'St$_1=\infty$' at -7,3.6 center front
set label 'St$_1 \simeq 0.6$' at 7,3.6 center front

file1='L/toto'
file2='S/toto'

set arrow from 0,0 to 0,4 front nohead

j=10
jj=100
k=3600


k1=7
k2=14
k3=28
k4=56
k5=112
k6=224
k7=448
k8=896
k9=1792
k10=3584

#stats file1 u 1:2 nooutput
#set xrange [STATS_min_x:STATS_max_x]

f1(x) = x>10 ? 1.4*(x-10)**2 + 0.4 : 1/0
f2(x) = x<9 ? -0.44*(x-10) + 0.4 : 1/0
f3(x) = x<-10 ? 0.55*(x+10)**2 + 0.25 : 1/0
f4(x) = x>-9 ? 0.38*(x+10) + 0.1 : 1/0

s=10
s2=100

plot [-12:12][0:4] 	f1(x) w p pt 7 lc rgb 'red',\
			f2(x) w p pt 7 lc rgb 'red',\
			f3(x) w p pt 7 lc rgb 'red',\
			f4(x) w p pt 7 lc rgb 'red',\
     			file1 every :::k1::k1 u 1:2 w l lt 1 lc rgb Color1,\
			file1 every :::k2::k2 u 1:2 w l lt 1 lc rgb Color1,\
			file1 every :::k3::k3 u 1:2 w l lt 1 lc rgb Color1,\
			file1 every :::k4::k4 u 1:2 w l lt 1 lc rgb Color1,\
			file1 every :::k5::k5 u 1:2 w l lt 1 lc rgb Color1,\
			file1 every :::k6::k6 u 1:2 w l lt 1 lc rgb Color1,\
			file1 every :::k7::k7 u 1:2 w l lt 1 lc rgb Color1,\
			file1 every :::k8::k8 u 1:2 w l lt 1 lc rgb Color1,\
			file1 every :::k9::k9 u 1:2 w l lt 1 lc rgb Color1,\
			file1 every :::k10::k10 u 1:2 w l lt 1 lc rgb Color1,\
		   	file2 every :::k1::k1 u 1:2 w l lt 1 lc rgb Color1,\
			file2 every :::k2::k2 u 1:2 w l lt 1 lc rgb Color1,\
			file2 every :::k3::k3 u 1:2 w l lt 1 lc rgb Color1,\
			file2 every :::k4::k4 u 1:2 w l lt 1 lc rgb Color1,\
			file2 every :::k5::k5 u 1:2 w l lt 1 lc rgb Color1,\
			file2 every :::k6::k6 u 1:2 w l lt 1 lc rgb Color1,\
			file2 every :::k7::k7 u 1:2 w l lt 1 lc rgb Color1,\
			file2 every :::k8::k8 u 1:2 w l lt 1 lc rgb Color1,\
			file2 every :::k9::k9 u 1:2 w l lt 1 lc rgb Color1,\
			file2 every :::k10::k10 u 1:2 w l lt 1 lc rgb Color1,\
