reset
set terminal push
x=8.6
No=1.6180339887
set terminal epslatex standalone linewidth 2 rounded \
  dashlen 4 color '' 10 size (x)cm,(x/No)cm colortext
set output 'epslatex.tex'
set encoding iso_8859_1
set format x '$10^{%L}$'
set format y '$10^{%L}$'
set xlabel '$H_{min}$'
set ylabel '$-d\bar{H}/dt$'
set mxtics 10
set mytics 10
set style line 12 lc rgb '#ddccdd' lt 1 lw 1.5
set style line 13 lc rgb '#ddccdd' lt 1 lw 0.5
set grid xtics mxtics ytics mytics back ls 12, ls 13
set key left bottom

Color1='#0065A5'

f(x) = (x>1e-4 && x<1e-2) ? 1000*x**(2.5) : 1/0
set label '$H_{min}^{2/5}$' at 2e-3,0.00001 left front

h(x) = (x>1 && x<50) ? 0.03*x**(-1./4.) : 1/0
#set label '$\tau^{-1/4}$' at 5,0.03 left front

#set label '$H_{min}$' at 0.01,0.005 left front
#set label '$H_0$' at 0.1,0.05 left front

g(x) = (x>10 && x<500) ? 0.007*x**(-2./3.) : 1/0
i(x) = (x>10 && x<500) ? 0.04*x**(-2./3.) : 1/0
#set label '$\tau^{-2/3}$' at 6,0.002 left front tc 'red'

file1='S/Hmoy.txt'
file2='L/Hmoy.txt'

set log; 
plot [:][:] file1 u 1:2 w l lt 1 lw 2 lc rgb Color1 t '',\
file2 u 1:2 w l lt 1 lw 2 lc "red" t '',\
f(x) lt 1 lc "black" t ''

unset log

