reset
set terminal push
x=8.6
No=1.6180339887
set terminal epslatex standalone linewidth 2 rounded \
  dashlen 4 color '' 10 size (x)cm,(x/No)cm colortext
set output 'epslatex.tex'
set encoding iso_8859_1
set format x '$10^{%L}$'
set format y '$10^{%L}$'
set multiplot
set xlabel '$\tau$'
set mxtics 10
set mytics 10
set style line 12 lc rgb '#ddccdd' lt 1 lw 1.5
set style line 13 lc rgb '#ddccdd' lt 1 lw 0.5
#set grid xtics mxtics ytics mytics back ls 12, ls 13
set key left bottom

Color1='#0065A5'

f(x) = (x>1 && x<50) ? 0.0016*x**(-1./2.) : 1/0
set label 1 '$\tau^{-1/2}$' at 5,0.0002 left front

h(x) = (x>1 && x<50) ? 0.01*x**(-1./4.) : 1/0
set label 2 '$\tau^{-1/4}$' at 5,0.01 left front

set label 3 '$H_{min}^\star$' at 0.05,0.005 left front
set label 4 '$\bar{H}^\star$' at 0.05,0.02 left front

g(x) = (x>10 && x<500) ? 0.008*x**(-2./3.) : 1/0
i(x) = (x>10 && x<500) ? 0.04*x**(-2./3.) : 1/0
set label 5 '$\tau^{-2/3}$' at 120,0.0007 left front tc 'red'

file1='S/Hmin.txt'
file2='L/Hmin.txt'

set log; 
plot [:1000][1e-4:] file1 u 1:3 w l lt 3 lw 2 lc "black" t '',\
file1 u 1:6 w l lt 3 lw 2 lc "black" t '',\
file2 u 1:3 w l lt 1 lw 2 lc rgb Color1 t '',\
file2 u 1:6 w l lt 1 lw 2 lc rgb Color1 t '',\
f(x) lt 1 lc "black" t '',\
h(x) w l lt 1 lc "black" t '',\
g(x) w l lt 1 lc "red" t ''
#i(x) w l lt 1 lc "red" t ''
#file2 u 1:6 w l lt 1 lw 2 lc "black" t '',\
#file2 u 1:(-$7) w l lt 1 t 'Q1',\
#file2 u 1:(-$8) w l lt 2 t 'Q2',\
#file2 u 1:(-$9) w l lt 3 t 'Q3'

     set size 0.45,0.45
     set origin 0.12,0.18
unset grid
set format x ''
set format y ''
     unset xlabel
     unset ylabel
unset label 1
unset label 2
unset label 3
unset label 4
unset label 5
set nokey

file3='S/Hmoy.txt'
file4='L/Hmoy.txt'
Bo = 1.01159
St2 = 0.000125018

j(x) = (x>1e-4 && x<5e-3) ? 1./Bo**(3./4.)/St2*x**(2.5) : 1/0
set label '$\frac{H_{min}^{\star 5/2}}{Bo^{3/4} St_2}$' at 1.1e-4,0.1 left front tc 'red' 

plot [:][:] file3 u 1:2 w l lt 3 lw 2 lc "black" t '',\
file4 u 1:2 w l lt 1 lw 2 lc rgb Color1 t '',\
j(x) lt 1 lc "red" t ''

unset log

