% This program calculates a scaling factor F for FBG sensors that can be
% used to convert FBG wavelength into pressure.


%% Loading various data and plot settings
close all
clear all

startdate=datetime(2019,5,22,0,1,0);
stopdate=datetime(2019,5,24,12,0,0);

load_fbg=1;     % FBG data
load_pump=1;    % pump status on/off
load_divers=1;  % diver data

[y1,m1,d1]=ymd(startdate);
[y2,m2,d2]=ymd(stopdate);

if y1==2018
    pumpset=1;
    diverset=1;
elseif y1==2019
    pumpset=2;
    diverset=2;
end


if load_fbg==1
    datarange = datetime(y1,m1,d1):caldays(1):datetime(y2,m2,d2);
    formatOut = 'yyyymmdd';
    Date=cellstr(datestr(datarange,formatOut));

    FBGData=[];
    for dd=1:length(Date)
        datafile=['mat\' Date{dd},'Hyperion.mat'];
        if isfile(datafile)
            load(datafile)
            FBGData=[FBGData;Meandata];
        end

    end
    Meandata=FBGData;
end

if load_divers==1
    eval(['load(''mat\DiversSet' num2str(diverset) '.mat'')'])
end


if load_pump==1
    eval(['load(''mat\PumpSet' num2str(pumpset) '.mat'')'])
    [~,p_start] = min(abs(datenum(startdate)-Pump.TimeStamp));
    [~,p_stop] = min(abs(datenum(stopdate)-Pump.TimeStamp));
    Pump([1:p_start-1,p_stop+1:end],:)=[];
end


%% Calculating pressure from divers

% Divers do not have exactly the same timestamp, need to be matched
sampling_time=5; % seconds
TimeStampI=datenum(startdate:seconds(sampling_time):stopdate)';
D11I=interp1(D11.TimeStamp,D11.Pressure,TimeStampI);
D15tI=interp1(D15t.TimeStamp,D15t.Pressure,TimeStampI);
D15bI=interp1(D15b.TimeStamp,D15b.Pressure,TimeStampI);
D12I=interp1(D12.TimeStamp,D12.Pressure,TimeStampI);
D9bI=interp1(D9b.TimeStamp,D9b.Pressure,TimeStampI);
D9tI=interp1(D9t.TimeStamp,D9t.Pressure,TimeStampI);
% pressure from all divers is averaged, \Delta p in the manuscript 
Pressure=mean([D15bI,D15tI,D11I,D12I,D9tI,D9bI],2);


% parsing pressure curve into intervals is based on times when w8-12
% started/stopped extracting. See Well_Map_storage.png
onoffe=[];
for well=8:12
    eval(['onoffe=[onoffe;find(abs(diff(Pump.Ext' num2str(well) '))>0)];'])
end
onoffe=unique(sort(onoffe,'ascend'));
        
figure
plot(TimeStampI-TimeStampI(1),Pressure-Pressure(1))
hold on
for i=1:length(onoffe)
plot([Pump.TimeStamp(onoffe(i)+2) Pump.TimeStamp(onoffe(i)+2)]-TimeStampI(1),[-3e3 3e3],'--k')
hold on
end


%% F calculation
fibers=1:9;

for fiber=fibers
    Fiberdata=Meandata(Meandata(:,10)==fiber,:);
    for s=1:8
        data(:,s)=movmean((Fiberdata(:,s+1)),30);
        % FBG data are interpolated to match the diver time stamp 
        dataI(:,s)=interp1(Fiberdata(:,1),data(:,s),TimeStampI);
       
        % looping through intervals
        for o=1:length(onoffe)-1
            t2=find(Pump.TimeStamp(onoffe(o+1)+2)==TimeStampI); %+2 min in pump data, time delay
            t1=find(Pump.TimeStamp(onoffe(o)+2)==TimeStampI);
            DLambda(o,s)=dataI(t2,s)-dataI(t1,s); % \Delta\lambda_c in the manuscript
            DL(o,s)=((dataI(t2,s)-dataI(t1,s))/dataI(t1,s)); % \Delta\lambda_c/\lambda_0 in the manuscript
            DP(o,s)=(Pressure(t2)-Pressure(t1)); % \Delta p in the manuscript
        end
        
    end
    
    % Fint is the scaling factor calculated at each interval
    Fint=DL./DP;
      
      
    % delete noisy sensors, their response on each interval is smaller than 1 pm
    N=max(DLambda)*1000;
    noisy=find(N<1);
    % invalid data, decresing when pressure is increasing and vice versa
    Fint(Fint<0)=NaN;
    
    % F is an average factor from all intervals
    F(fiber,:)=nanmean(Fint);
    F(fiber,noisy)=NaN;
end

% these two sensors decouple a lot when w13 starts extracting
F(2,6)=NaN;
F(4,8)=NaN;
