% uses findpeaks to find the real gw temperature. Divers only measure
% groundwater temperature at the moment when w13 is switched off

load('mat\DiversUncompensated20190813-0821.mat')
startdate=datetime(2019,8,16,0,0,0);
stopdate=datetime(2019,8,21,13,2,0);
inf_stop=datenum(2019,8,14,15,2,0); % time axis 0

diver={'11','15b','15t','12','9b','9t'};
for d=1:6
    eval(['TimeStampD=D' diver{d} 'Uncompensated.TimeStamp;'])
    [~,d_start] = min(abs(datenum(startdate)-TimeStampD));
    [~,d_stop] = min(abs(datenum(stopdate)-TimeStampD));
    eval(['D' diver{d} 'Uncompensated([1:d_start-1,d_stop+1:end],:)=[];'])
end

load('mat\PumpSet2.mat')
[~,p_start] = min(abs(datenum(startdate)-Pump.TimeStamp));
[~,p_stop] = min(abs(datenum(stopdate)-Pump.TimeStamp));
Pump([1:p_start-1,p_stop+1:end],:)=[];
% Pump.Ext13(Pump.Ext13==0)=NaN;

pump_off=find(diff(Pump.Ext13)==-1);

%% diver 15t
[pos_pks,pos_loc] = findpeaks(D15tUncompensated.Temperature,'MinPeakProminence',0.06,'MinPeakDistance',50);
[neg_pks,neg_loc] = findpeaks(-D15tUncompensated.Temperature,'MinPeakProminence',0.06,'MinPeakDistance',50);
locs=sort([pos_loc;neg_loc]);

L=[];
for off=pump_off'
    A=find(abs(D15tUncompensated.TimeStamp(locs)-Pump.TimeStamp(off))<0.05);
    L=[L,locs(A(end))];
    hold on
end
L15t=L; % only locations when w13 was switched off

%% diver 15b
[pos_pks,pos_loc] = findpeaks(D15bUncompensated.Temperature,'MinPeakProminence',0.06,'MinPeakDistance',50);
[neg_pks,neg_loc] = findpeaks(-D15bUncompensated.Temperature,'MinPeakProminence',0.06,'MinPeakDistance',50);
locs=sort([pos_loc;neg_loc]);

L=[];
for off=pump_off'
    A=find(abs(D15bUncompensated.TimeStamp(locs)-Pump.TimeStamp(off))<0.05);
    L=[L,locs(A(end))];
    hold on
end
L15b=L; % only locations when w13 was switched off

%% diver 11
[pks, locs]=findpeaks(D11Uncompensated.Temperature,'MinPeakProminence',0.05,'MinPeakDistance',200);

L=[];
for off=pump_off'
    A=find(abs(D11Uncompensated.TimeStamp(locs)-Pump.TimeStamp(off))<0.05);
    L=[L,locs(A(end))];
    hold on
end
L11=L;  % only locations when w13 was switched off
