% Plots raw FBG data 
%% Loading various data and plot settings
close all

% for pressure calculation
startdate=datetime(2019,8,12,0,2,0); % start injection in w13
stopdate=startdate+caldays(3);


load_fbg=1;     % FBG data


colorarray=[0,0,1;0,0,0.8;0,0,0.6;0,0,0.4;0,1,0;0,0.8,0;0,0.6,0;1,0,0;0.8,0,0;0.6,0,0;0,0,0.4;0,0.4,0;0.4,0,0];
depth=[-17,-17.7,-18.4,-19.1,-19.8,-20.5,-21.2,-21.9;-22.6,-23.3,-24,-24.7000000000000,-25.4000000000000,-26.1000000000000,-26.8000000000000,-27.5000000000000;-28.2000000000000,-28.9000000000000,-29.6000000000000,-30.3000000000000,-31,-31.7000000000000,-32.4000000000000,-33.1000000000000;-17,-17.7000000000000,-18.4000000000000,-19.1000000000000,-19.8000000000000,-20.5000000000000,-21.2000000000000,-21.9000000000000;-22.6000000000000,-23.3000000000000,-24,-24.7000000000000,-25.4000000000000,-26.1000000000000,-26.8000000000000,-27.5000000000000;-28.2000000000000,-28.9000000000000,-29.6000000000000,-30.3000000000000,-31,-31.7000000000000,-32.4000000000000,-33.1000000000000;-17,-17.7000000000000,-18.4000000000000,-19.1000000000000,-19.8000000000000,-20.5000000000000,-21.2000000000000,-21.9000000000000;-22.6000000000000,-23.3000000000000,-24,-24.7000000000000,-25.4000000000000,-26.1000000000000,-26.8000000000000,-27.5000000000000;-28.2000000000000,-28.9000000000000,-29.6000000000000,-30.3000000000000,-31,-31.7000000000000,-32.4000000000000,-33.1000000000000;0,0,0,0,0,0,0,0];


[y1,m1,d1]=ymd(startdate);
[y2,m2,d2]=ymd(stopdate);

if y1==2018
    pumpset=1;
    diverset=1;
elseif y1==2019
    pumpset=2;
    diverset=2;
end


if load_fbg==1
    datarange = datetime(y1,m1,d1):caldays(1):datetime(y2,m2,d2);
    formatOut = 'yyyymmdd';
    Date=cellstr(datestr(datarange,formatOut));

    FBGData=[];
    for dd=1:length(Date)
        datafile=['mat\' Date{dd},'Hyperion.mat'];
        if isfile(datafile)
            load(datafile)
            FBGData=[FBGData;Meandata];
        end

    end
    Meandata=FBGData;
    [~,fbg_start] = min(abs(datenum(startdate)-Meandata(:,1)));
    [~,fbg_stop] = min(abs(datenum(stopdate)-Meandata(:,1)));
    Meandata([1:fbg_start-1,fbg_stop+1:end],:)=[];

end


%% Plot raw FBG data
fibers=1:9;
meannr=30;
for fiber=fibers
    h=figure('units','normalized','outerposition',[0 0 1 1]);%      
    Fiberdata=Meandata(Meandata(:,10)==fiber,:);

    if ~isempty(Fiberdata)
        for s=1:8
            subplot(2,4,s)
            plot(Fiberdata(:,1),1000*movmean((Fiberdata(:,1+s)-Fiberdata(1,1+s)),meannr));

            m=nanmin(1000*movmean((Fiberdata(:,1+s)-Fiberdata(1,1+s)),meannr));
            M=nanmax(1000*movmean((Fiberdata(:,1+s)-Fiberdata(1,1+s)),meannr));
            
           % labels and settings
            ylim([m M])
            datetick('x','mm/dd HH:MM','keepticks','keeplimits')
            title(['Depth ' num2str(depth(fiber,s)) ' m Fiber ' num2str(fiber) ' sensor ' num2str(s)])
            ylabel('{\Delta \lambda} [pm]')
        end
    end
end



