% Plots pressure change after the start of extraction from w13 as a
% function of depth for 3 fiber bundles

close all
dp=-dp; % if needed, if the dp FBG data contains extraction stop not start
figure
barh([-depth(3,:),-depth(2,:),-depth(1,:)],[dp(3,:),dp(2,:),dp(1,:)],0.3)
grid on
title('Bundle C')
xlim([-5e4 4e4])

figure
dp11=max(D11.Pressure)-min(D11.Pressure);
dp11=-dp11; % if needed, if the dp diver data contains extraction stop not start
barh([18.8, 23.5],[dp11, dp11],0.4,'g')
hold on
barh([-depth(6,:),-depth(5,:),-depth(4,:)],[dp(6,:),dp(5,:),dp(4,:)],0.3)
grid on
ax = gca;
ax.YDir = 'reverse';
title('Bundle B')
xlim([-5e4 4e4])
xlabel('{\Delta p} (Pa)')
ylabel('Depth (m)')
legend('Diver in P1','FBG sensors','location','east')

figure
dp15t=max(D15t.Pressure)-min(D15t.Pressure);
dp15b=max(D15b.Pressure)-min(D15b.Pressure);
dp15b=-dp15b; % if needed, if the dp diver data contains extraction stop not start
dp15t=-dp15t; % if needed, if the dp diver data contains extraction stop not start
barh([18.8,23.5],[dp15t,dp15b],0.4,'g')
hold on
barh([-depth(9,:),-depth(8,:),-depth(7,:)],[dp(9,:),dp(8,:),dp(7,:)],0.3)
grid on
ax = gca;
ax.YDir = 'reverse';
title('Bundle A')
xlim([-5e4 4e4])
xlabel('{\Delta p} (Pa)')
ylabel('Depth (m)')
legend('Divers in P2','FBG sensors','location','east')


