% Plots rescaled FBG data as pressure when w13 was extracting, the pressure
% range from min to max is displayed in the manuscript

%% Loading various data and plot settings
close all

% for pressure calculation
startdate=datetime(2019,8,1,0,0,1); % w13 was extracting on this day
stopdate=startdate+caldays(1);


load_fbg=1;     % FBG data
load_pump=1;    % pump status on/off
load_divers=1;  % divers pressure and temperature


colorarray=[0,0,1;0,0,0.8;0,0,0.6;0,0,0.4;0,1,0;0,0.8,0;0,0.6,0;1,0,0;0.8,0,0;0.6,0,0;0,0,0.4;0,0.4,0;0.4,0,0];
depth=[-17,-17.7,-18.4,-19.1,-19.8,-20.5,-21.2,-21.9;-22.6,-23.3,-24,-24.7000000000000,-25.4000000000000,-26.1000000000000,-26.8000000000000,-27.5000000000000;-28.2000000000000,-28.9000000000000,-29.6000000000000,-30.3000000000000,-31,-31.7000000000000,-32.4000000000000,-33.1000000000000;-17,-17.7000000000000,-18.4000000000000,-19.1000000000000,-19.8000000000000,-20.5000000000000,-21.2000000000000,-21.9000000000000;-22.6000000000000,-23.3000000000000,-24,-24.7000000000000,-25.4000000000000,-26.1000000000000,-26.8000000000000,-27.5000000000000;-28.2000000000000,-28.9000000000000,-29.6000000000000,-30.3000000000000,-31,-31.7000000000000,-32.4000000000000,-33.1000000000000;-17,-17.7000000000000,-18.4000000000000,-19.1000000000000,-19.8000000000000,-20.5000000000000,-21.2000000000000,-21.9000000000000;-22.6000000000000,-23.3000000000000,-24,-24.7000000000000,-25.4000000000000,-26.1000000000000,-26.8000000000000,-27.5000000000000;-28.2000000000000,-28.9000000000000,-29.6000000000000,-30.3000000000000,-31,-31.7000000000000,-32.4000000000000,-33.1000000000000;0,0,0,0,0,0,0,0];


[y1,m1,d1]=ymd(startdate);
[y2,m2,d2]=ymd(stopdate);

if y1==2018
    pumpset=1;
    diverset=1;
elseif y1==2019
    pumpset=2;
    diverset=2;
end


if load_fbg==1
    datarange = datetime(y1,m1,d1):caldays(1):datetime(y2,m2,d2);
    formatOut = 'yyyymmdd';
    Date=cellstr(datestr(datarange,formatOut));

    FBGData=[];
    for dd=1:length(Date)
        datafile=['mat\' Date{dd},'Hyperion.mat'];
        if isfile(datafile)
            load(datafile)
            FBGData=[FBGData;Meandata];
        end

    end
    Meandata=FBGData;
    [~,fbg_start] = min(abs(datenum(startdate)-Meandata(:,1)));
    [~,fbg_stop] = min(abs(datenum(stopdate)-Meandata(:,1)));
    Meandata([1:fbg_start-1,fbg_stop+1:end],:)=[];

end

if load_pump==1
    eval(['load(''mat\PumpSet' num2str(pumpset) '.mat'')'])
    [~,p_start] = min(abs(datenum(startdate)-Pump.TimeStamp));
    [~,p_stop] = min(abs(datenum(stopdate)-Pump.TimeStamp));
    Pump([1:p_start-1,p_stop+1:end],:)=[];

    % pumping regime change lines for both ext and inf
    onoffe=[];
    for well=[1:3,5:13]
        eval(['onoffe=[onoffe;find(abs(diff(Pump.Ext' num2str(well) '))>0)];'])
    end
    onoffe=unique(onoffe);
    onoffi=[];
    for cluster=1:3
        eval(['onoffi=[onoffi;find(abs(diff(Pump.Inf' num2str(cluster) '))>0)];'])
    end
    onoffi=unique(onoffi);


    for well=[1:3,5:13]
        eval(['Pump.Ext' num2str(well) '(Pump.Ext' num2str(well) '==0)=NaN;'])
    end

    % pumps order in the graphs
    Pump.Ext1(Pump.Ext1==1)=-1;
    Pump.Ext2(Pump.Ext2==1)=-2;
    Pump.Ext3(Pump.Ext3==1)=-3;
    Pump.Ext11(Pump.Ext11==1)=-4;
    Pump.Ext5(Pump.Ext5==1)=-5;
    Pump.Ext6(Pump.Ext6==1)=-6;
    Pump.Ext7(Pump.Ext7==1)=-7;
    Pump.Ext12(Pump.Ext12==1)=-8;
    Pump.Ext8(Pump.Ext8==1)=-9;
    Pump.Ext9(Pump.Ext9==1)=-10;
    Pump.Ext10(Pump.Ext10==1)=-11;
    Pump.Ext13(Pump.Ext13==1)=-12;

    for cluster=1:3
        eval(['Pump.Inf' num2str(cluster) '(Pump.Inf' num2str(cluster) '==1)=cluster;']) 
        eval(['Pump.Inf' num2str(cluster) '(Pump.Inf' num2str(cluster) '==0)=NaN;'])
    end
end

if load_divers==1
    eval(['load(''mat\DiversSet' num2str(diverset) '.mat'')'])
    diver={'11','15b','15t','12','9b','9t'};
    for d=1:6
        eval(['D' diver{d} '.TimeStamp=D' diver{d} '.TimeStamp-5/60/24;']) % SHIFTED BY 1 min because model input cannot start later than output
        eval(['TimeStamp=D' diver{d} '.TimeStamp;'])
        [~,d_start] = min(abs(datenum(startdate)-TimeStamp));
        [~,d_stop] = min(abs(datenum(stopdate)-TimeStamp));
        eval(['D' diver{d} '([1:d_start-1,d_stop+1:end],:)=[];'])
    end
end

%% Plot pressure from FBG sensors vs. pump regime
fibers=1:9;
meannr=30;
for fiber=fibers
    h=figure('units','normalized','outerposition',[0 0 1 1]);%      
    Fiberdata=Meandata(Meandata(:,10)==fiber,:);

    if ~isempty(Fiberdata)
        for s=1:8
            subplot(2,4,s)
            [ax, h1, h2]=plotyy(Fiberdata(:,1),1/F(fiber,s)*movmean((Fiberdata(:,1+s)-Fiberdata(1,1+s))/Fiberdata(1,1+s),meannr),Pump.TimeStamp,zeros(size(Pump.TimeStamp)));

            m=nanmin(1/F(fiber,s)*movmean((Fiberdata(:,1+s)-Fiberdata(1,1+s))/Fiberdata(1,1+s),meannr));
            M=nanmax(1/F(fiber,s)*movmean((Fiberdata(:,1+s)-Fiberdata(1,1+s))/Fiberdata(1,1+s),meannr));
            
            % \delta p in the manuscript when w13 was extracting, further
            % used in Plot_pressure_layers.m
            if abs(m)>abs(M)
                dp(fiber,s)=-(M-m);
            else
                dp(fiber,s)=(M-m);
            end
            
            hold(ax(1))
            hold(ax(2))

            %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
            % lines showing pumps on
            plot(ax(2),Pump.TimeStamp,Pump.Inf1,'color','b','LineStyle','--')
            plot(ax(2),Pump.TimeStamp,Pump.Inf2,'color','g','LineStyle','--') 
            plot(ax(2),Pump.TimeStamp,Pump.Inf3,'color','r','LineStyle','--')

            for well=[1:3,5:13]
                eval(['h3=plot(ax(2),Pump.TimeStamp,Pump.Ext' num2str(well) ',''LineWidth'',3,''color'',colorarray(well,:));'])
                h3.Color(4) =0.5; % opacity
            end 

            %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
            % regime change lines
            if ~isempty(onoffe)
                    for o=1:length(onoffe)
                        plot(ax(2),[Pump.TimeStamp(1+onoffe(o)-1),Pump.TimeStamp(1+onoffe(o)-1)],[-14,4],'LineStyle',':','Color','k')
                    end
            end
            if ~isempty(onoffi)
                    for o=1:length(onoffi)
                        plot(ax(2),[Pump.TimeStamp(1+onoffi(o)-1),Pump.TimeStamp(1+onoffi(o)-1)],[-14,4],'LineStyle',':','Color','k')
                    end
            end


            % labels and settings
            set(h1,'color','k')
            set(h1,'LineWidth',2);
            set(h2, 'color','w')
            set(h2,'LineStyle','--');
            set(gca,'color','w')
            uistack(h1,'top')
            set(ax(1),'YColor','k')
            yticks(ax(1),-4e4:1e4:5e4)  
            ylim(ax(2),[-13 4])
            yticks(ax(2),-13:4)
            yticklabels(ax(2),{'','e13','e10','e9','e8','e12','e7','e6','e5','e11','e3','e2','e1','','i1','i2','i3'})
            ylim(ax(1),[-4e4 5e4])
            datetick('x','mm/dd HH:MM','keepticks','keeplimits')
            title(['Depth ' num2str(depth(fiber,s)) ' m Fiber ' num2str(fiber) ' sensor ' num2str(s)])
            ylabel('{\Delta p} [Pa]')
        end
    end
end
