% plot heat maps, flowrates, temperature slices from FBG data

clear all
close all

% load horizontal flow data measured inside of w13
load('mat\HorizontalFlow.mat')

bundle='A';

switch bundle
    case 'A'
        fibers=7:9;
    case 'B'
        fibers=4:6;
    case 'C'
        fibers=1:3;
end
    

depth=[-17,-17.7,-18.4,-19.1,-19.8,-20.5,-21.2,-21.9;-22.6,-23.3,-24,-24.7,-25.4000000000000,-26.1000000000000,-26.8000000000000,-27.5000000000000;-28.2000000000000,-28.9000000000000,-29.6000000000000,-30.3000000000000,-31,-31.7000000000000,-32.4000000000000,-33.1000000000000;-17,-17.7000000000000,-18.4000000000000,-19.1000000000000,-19.8000000000000,-20.5000000000000,-21.2000000000000,-21.9000000000000;-22.6000000000000,-23.3000000000000,-24,-24.7000000000000,-25.4000000000000,-26.1000000000000,-26.8000000000000,-27.5000000000000;-28.2000000000000,-28.9000000000000,-29.6000000000000,-30.3000000000000,-31,-31.7000000000000,-32.4000000000000,-33.1000000000000;-17,-17.7000000000000,-18.4000000000000,-19.1000000000000,-19.8000000000000,-20.5000000000000,-21.2000000000000,-21.9000000000000;-22.6000000000000,-23.3000000000000,-24,-24.7000000000000,-25.4000000000000,-26.1000000000000,-26.8000000000000,-27.5000000000000;-28.2000000000000,-28.9000000000000,-29.6000000000000,-30.3000000000000,-31,-31.7000000000000,-32.4000000000000,-33.1000000000000;0,0,0,0,0,0,0,0];
% graphs in the manuscript start at t=1.4 days
skip=round(1.4*24*60); % 1.4 day in minutes

Data=[];
Lambda0=[];
for fiber=fibers
    for s=1:8
        eval(['load(''mat/ResidualsFiltered' num2str(fiber) num2str(s) '.mat'')'])
        outputs=residuals_filtered.OutputData;
        outputs=outputs(skip:end,:)';
        % gathers all data from all FBG sensors at selected fibers
        Data=[Data;outputs]; 
        Lambda=Lambda';
        Lambda0=[Lambda0;Lambda(:,skip)];
    end
end

DeltaLambda=Data-Data(:,1);
% conversion of FBG residuals to \Delta T
DeltaT=DeltaLambda./Lambda0/7.8e-6;
    
TimeStamp=skip+(1:size(Data,2));
Depth=sort(reshape(depth(fibers,:),1,[]),'descend');
[X,Y] = meshgrid(TimeStamp,Depth);

% interpolate the heat map from FBG data
[XI,YI] = meshgrid(TimeStamp,Depth(1):-0.1:Depth(end));
outputsI = interp2(X,Y,DeltaT,XI,YI);

%% plot FBG heat map and well flowrate
figure
m=min(min(outputsI));
M=max(max(outputsI));
subplot(1,2,1)
imagesc(TimeStamp/60/24,Depth(1):-0.1:Depth(end),outputsI,[-2,1])
colorbar
colormap jet
xlabel('Time (days)')
ylabel('Depth (m)')
set(gca,'YDir','normal')
title(['Fiber bundle ' bundle ''])
subplot(1,2,2)
% w13 was extracting at flowrate 143 m^3/h
plot(HorizontalFlowExt143.Q,-HorizontalFlowExt143.Depth)
hold on
% w13 was injecting at flowrate 66 m^3/h
plot(HorizontalFlowInf66.Q,-HorizontalFlowInf66.Depth,'o-')
ylim([-33 -17])
legend('Extraction','Infiltration')
xlabel('Flowrate (m^3/h)')
ylabel('Depth (m)')
title('Well w13')


%% plot temperature cross sections from depth intervals
% real groundwater temperature from divers
Real_diver_temperature


% Average FBG data instead of only cross section
if bundle=='A'
    [t,~]=find(YI(:,1)<-17.8 & YI(:,1)>-19.8);
    meanT1=mean(outputsI(t,:));
    figure
    plot(TimeStamp/60/24,meanT1)
    hold on
    plot(D15tUncompensated.TimeStamp(L15t)-inf_stop,D15tUncompensated.Temperature(L15t)-D15tUncompensated.Temperature(L15t(1)))
    xlim([D15tUncompensated.TimeStamp(L15t(1))-inf_stop, D15tUncompensated.TimeStamp(L15t(end))-inf_stop])
    xlabel('Time (days)')
    ylabel('{\Delta T} (degC)')
    
    [t,~]=find(YI(:,1)<-22.5 & YI(:,1)>-24.5);
    meanT2=mean(outputsI(t,:));
    plot(TimeStamp/60/24,meanT2,'--')
    hold on
    plot(D15bUncompensated.TimeStamp(L15b)-inf_stop,D15bUncompensated.Temperature(L15b)-D15bUncompensated.Temperature(L15b(1)),'--')
    xlim([D15bUncompensated.TimeStamp(L15b(1))-inf_stop, D15bUncompensated.TimeStamp(L15b(end))-inf_stop])
    title('Bundle A')
    legend('FBG sensors', 'Diver in P2','FBG sensors', 'Diver in P3')
    xlabel('Time (days)')
    ylabel('{\Delta T} (degC)')
end

if bundle=='B'
    [t,~]=find(YI(:,1)<-17.8 & YI(:,1)>-19.8);
    meanT1=mean(outputsI(t,:));
    [t,~]=find(YI(:,1)<-22.5 & YI(:,1)>-24.5);
    meanT2=mean(outputsI(t,:));
    meanT=mean([meanT1;meanT2]);
    
    figure
    plot(TimeStamp/60/24,meanT)
    hold on
    plot(D11Uncompensated.TimeStamp(L11)-inf_stop,D11Uncompensated.Temperature(L11)-D11Uncompensated.Temperature(L11(1)))
    xlim([D11Uncompensated.TimeStamp(L11(1))-inf_stop, D11Uncompensated.TimeStamp(L11(end))-inf_stop])
    title('Bundle B')
    legend('FBG sensors', 'Diver in P1')
    xlabel('Time (days)')
    ylabel('{\Delta T} (degC)')

end
