% Validating consolidation models and isolating FBG temperature contribution 

%% Loading various data and plot settings
close all
clear all

% VALIDATION DATASET
% choose this for RMSE calculation for validation dataset
% startdate=datetime(2019,7,6,1,0,0);
% stopdate=startdate+caldays(7);
% AFTER INFILTRATION
% choose this for isolating temperature contribution
startdate=datetime(2019,8,14,15,2,0);
stopdate=datetime(2019,8,21,12,2,0);

load_fbg=1;     % FBG data
load_pump=1;    % pump status on/off

[y1,m1,d1]=ymd(startdate);
[y2,m2,d2]=ymd(stopdate);

if y1==2018
    pumpset=1;
    diverset=1;
elseif y1==2019
    pumpset=2;
    diverset=2;
end

if load_fbg==1

    [y1,m1,d1]=ymd(startdate);
    [y2,m2,d2]=ymd(stopdate);
    datarange = datetime(y1,m1,d1):caldays(1):datetime(y2,m2,d2);
    formatOut = 'yyyymmdd';
    Date=cellstr(datestr(datarange,formatOut));

    FBGData=[];
    for dd=1:length(Date)
        file=['mat\', Date{dd},'Hyperion.mat'];
        if exist(file) > 0
            load(file)        
            FBGData=[FBGData;Meandata];
        end
    end
    Meandata=FBGData;
end

if load_pump==1
    eval(['load(''mat\PumpSet' num2str(pumpset) '.mat'')'])
    Pump.TimeStamp=Pump.TimeStamp; % For causality correction
    [~,p_start] = min(abs(datenum(startdate)-Pump.TimeStamp));
    [~,p_stop] = min(abs(datenum(stopdate)-Pump.TimeStamp));
    Pump([1:p_start-1,p_stop+1:end],:)=[];
end

%% Interpolate FBG data to match pump status timestamp
downnr=1; %min, currently Pump data is sampled each minute
PumpI=downsample(Pump,downnr);

meannr=60;
fibers=7;

for fiber=fibers
    Fiberdata=Meandata(Meandata(:,10)==fiber,:);
    eval(['Fiber' num2str(fiber) '.TimeStamp=Fiberdata(:,1);']) 
    % smooth raw FBG data
    eval(['Fiber' num2str(fiber) '.Data=smoothdata(Fiberdata(:,2:end)*1000,''sgolay'',meannr);']) % in pm from the start
     % interpolate FBG data on the same timestamp as pump status
    eval(['Fiber' num2str(fiber) '.DataI = interp1(Fiber' num2str(fiber) '.TimeStamp,Fiber' num2str(fiber) '.Data,PumpI.TimeStamp);'])

end

%% prepare dataset from FBG and pump status data
close all    
inputs_all=table2array(PumpI(:,2:13));
inputs=unique(inputs_all','rows');
% check: are there 12 unique rows?
size(inputs,1)

for s=1:8
    eval(['dataset = iddata(Fiber' num2str(fiber) '.DataI(:,s),inputs_all,downnr/60/24);'])
    dataset.TimeUnit='days';  
    pumps=[1:3,5:13];
    for p=1:numel(pumps)
        dataset.InputName{p} = ['Pump ', num2str(pumps(p)) ' status'];
        dataset.InputUnit{p} = '-';
    end

    Lambda=dataset.OutputData; % in pm
    dataset=detrend((dataset));

    figure
    eval(['load(''mat/MISOArx' num2str(fibers) num2str(s) '.mat'')'])
    [estimated,rmse,~]=compare(dataset,M);
    compare(dataset,M)
    RMSE(s)=rmse; % listed in the manuscript for validation data

    % residuals contain temperature contribution
    residuals = iddata(dataset.OutputData-estimated.OutputData,[],downnr/60/24);
    residuals.TimeUnit='days';

    figure
    plot(dataset)
    % smoothing residuals
    residuals_filtered=iddata(movmean(medfilt1(residuals.OutputData,5),1000),[],downnr/60/24);
    residuals_filtered.TimeUnit='days';
    hold on
    plot(residuals_filtered)

    % save residuals
%     eval(['save(''mat/ResidualsFiltered' num2str(fibers) num2str(s) '.mat'',''residuals_filtered'',''Lambda'')'])
end
