% Consolidation models from training data

%% Loading various data and plot settings
close all
clear all

% TRAINING DATASET
startdates={datetime(2019,7,30,1,0,0)};
stopdates={startdates{1}+caldays(5)};

fibers=7;

for s=1:8
    for da=1:length(startdates)
        startdate=startdates{da};
        stopdate=stopdates{da};
        
        load_fbg=1;     % FBG data
        load_pump=1;    % pump status on/off
  
        [y1,m1,d1]=ymd(startdate);
        [y2,m2,d2]=ymd(stopdate);

        if y1==2018
            pumpset=1;
            diverset=1;
        elseif y1==2019
            pumpset=2;
            diverset=2;
        end

        if load_fbg==1
            [y1,m1,d1]=ymd(startdate);
            [y2,m2,d2]=ymd(stopdate);
            datarange = datetime(y1,m1,d1):caldays(1):datetime(y2,m2,d2);
            formatOut = 'yyyymmdd';
            Date=cellstr(datestr(datarange,formatOut));

            FBGData=[];
            for dd=1:length(Date)
                load(['mat\', Date{dd},'Hyperion.mat'])
                FBGData=[FBGData;Meandata];
            end
            Meandata=FBGData;
        end


        if load_pump==1
            eval(['load(''mat\PumpSet' num2str(pumpset) '.mat'')'])
            Pump.TimeStamp=Pump.TimeStamp; % For causality correction
            [~,p_start] = min(abs(datenum(startdate)-Pump.TimeStamp));
            [~,p_stop] = min(abs(datenum(stopdate)-Pump.TimeStamp));
            Pump([1:p_start-1,p_stop+1:end],:)=[];
        end
        
        %% Interpolate FBG data to match pump status timestamp
        downnr=1; %min, currently Pump data is sampled each minute
        PumpI=downsample(Pump,downnr);

        meannr=60;
        for fiber=fibers
            Fiberdata=Meandata(Meandata(:,10)==fiber,:);
            eval(['Fiber' num2str(fiber) '.TimeStamp=Fiberdata(:,1);']) 
            % smooth raw FBG data
            eval(['Fiber' num2str(fiber) '.Data=smoothdata(Fiberdata(:,2:end)*1000,''sgolay'',meannr);']) % in pm from the start
            % interpolate FBG data on the same timestamp as pump status
            eval(['Fiber' num2str(fiber) '.DataI = interp1(Fiber' num2str(fiber) '.TimeStamp,Fiber' num2str(fiber) '.Data,PumpI.TimeStamp);'])
        end

        %% prepare dataset from FBG and pump status data
        inputs_all=table2array(PumpI(:,2:13));
        inputs=unique(inputs_all','rows');
        % check: are there 12 unique rows?
        size(inputs,1)

        eval(['dataset = iddata(Fiber' num2str(fiber) '.DataI(:,s),inputs_all,downnr/60/24);'])
        dataset.TimeUnit='days';  
        pumps=[1:3,5:13];
        for p=1:numel(pumps)
            dataset.InputName{p} = ['Pump ', num2str(pumps(p)) ' status'];
            dataset.InputUnit{p} = '-';
        end

        eval(['dataset' num2str(da) '=detrend((dataset));'])
    end
    
    % merge more datasets here if needed, more input data can be added
%     Dataset=merge(dataset1,dataset2);
    Dataset=dataset1;

    %% ARX parameters
    nr_inputs=size(inputs,1);
    nr_outputs=length(s);
    na=6*ones(nr_outputs,nr_outputs);

    nb=2*ones(nr_outputs,nr_inputs);
    nb(:,12)=8; % fiber=6 s=7 then nb(:,12)=7
    % extra time shift +1 minute to all because pump status data are
    % delayed compared to FBG data
    nk=2*ones(nr_outputs,nr_inputs); 
    nk(:,12)=1;
    
    
    %% ARX model
    M = arx(Dataset,[na nb nk]);
    figure
    [estimated,rmse,~]=compare(Dataset,M);
    compare(Dataset,M)
    RMSE(s)=rmse; % listed in the manuscript for training data

    % step response to all pumps
    figure
    step(M)

    % save generated ARX models for validation
    eval(['save(''mat/MISOArx' num2str(fiber) num2str(s) ''',''M'')'])
    
    %% minimizing errors
    [A,B,C,D,F,dA,dB,dC,dD,dF] = polydata(M);
    figure
    % percentual standard deviations vs. parameters. Can be minimized by
    % changing the number of ARX parameters
    plot(dA{1}./A{1}) 
    
    figure
    overfit=zeros(12,nb(12));
    for i=1:12
        overfit(i,1:length(B{1,i}))=dB{1,i}./B{1,i};
        plot(dB{1,i}./B{1,i})
        hold on
    end
    
end
