%save data to ascii
clear all
clc
cd('E:\code')%set working directory
load('gridpara.mat')%grid raw data
lonlat1=gridpara(1:length(gridpara)/2,1:5);%centre of grid of historical period
load('value_added_ssps_final.mat')

lon=min(lonlat1(:,3)):1/12:max(lonlat1(:,3));lon=lon';
lat=min(lonlat1(:,4)):1/12:max(lonlat1(:,4));lat=lat';
xllcorner=min(lon)-1/24;
yllcorner=min(lat)-1/24;
cellsize=0.083333;

for t=1:81
    for j=1:5
        adata=primary_ssps_value_final(:,t,j);
        raster=zeros(length(lat),length(lon))*nan;
        for i=1:length(adata)
            xx=find(abs(lon(:,1)-lonlat1(i,3))<0.01);
            yy=find(abs(lat(:,1)-lonlat1(i,4))<0.01);
            raster(yy,xx)=adata(i);
        end
        ascWrite(['Primary_SSP' num2str(j) '_' num2str(t+2019) '.asc'],xllcorner, yllcorner, cellsize, -9999, raster)
        adata=secondary_ssps_value_final(:,t,j);
        raster=zeros(length(lat),length(lon))*nan;
        for i=1:length(adata)
            xx=find(abs(lon(:,1)-lonlat1(i,3))<0.01);
            yy=find(abs(lat(:,1)-lonlat1(i,4))<0.01);
            raster(yy,xx)=adata(i);
        end
        ascWrite(['Secondary_SSP' num2str(j) '_' num2str(t+2019) '.asc'],xllcorner, yllcorner, cellsize, -9999, raster)
        adata=tertiary_ssps_value_final(:,t,j);
        raster=zeros(length(lat),length(lon))*nan;
        for i=1:length(adata)
            xx=find(abs(lon(:,1)-lonlat1(i,3))<0.01);
            yy=find(abs(lat(:,1)-lonlat1(i,4))<0.01);
            raster(yy,xx)=adata(i);
        end
        ascWrite(['Tertiary_SSP' num2str(j) '_' num2str(t+2019) '.asc'],xllcorner, yllcorner, cellsize, -9999, raster)
    end
end

