%final step, calculate the value-added for three industries under ssps
clear all
clc
cd('E:\code')%set working directory
load('gridpara.mat')%grid raw data
lonlat1=gridpara(1:length(gridpara)/2,1:5);%centre of grid of historical period
%ratio of the provincial value estimated by gam
for i=1:5
    load(['pred_grid_ssp' num2str(i) '.mat'])
    primary_ssps_pp(:,:,i)=pred_primary;
    secondary_ssps_pp(:,:,i)=pred_secondary;
    tertiary_ssps_pp(:,:,i)=pred_tertiary;
end
%load projected provincial value-added and calculate gridded value
provno=unique(gridpara(:,1));
primary_ssps_value=zeros(length(lonlat1),81,5)*nan;
secondary_ssps_value=zeros(length(lonlat1),81,5)*nan;
tertiary_ssps_value=zeros(length(lonlat1),81,5)*nan;
for i=1:length(provno)%31 province
    for s=1:5%5 ssps
        list=dir(['E:\code\provincial projection\' num2str(provno(i)) '.' '*.xlsx']);
        gdp=xlsread(['E:\codeprovincial projection\' list.name],['SSP' num2str(s)],'r3:t93');%load the projected value-added
        gdp=gdp*100;%unit:million yuan
        allgdp1(:,i,s)=gdp(:,1);
        allgdp2(:,i,s)=gdp(:,2);
        allgdp3(:,i,s)=gdp(:,3);
        a=find(lonlat1(:,1)==provno(i));
        primary_ssps_value(a,:,s)=primary_ssps_pp(a,6:end,s).*repmat(gdp(11:end,1)',length(a),1)/100;
        secondary_ssps_value(a,:,s)=secondary_ssps_pp(a,6:end,s).*repmat(gdp(11:end,2)',length(a),1)/100;
        tertiary_ssps_value(a,:,s)=tertiary_ssps_pp(a,6:end,s).*repmat(gdp(11:end,3)',length(a),1)/100;
    end
end
%calibration by calibration factor
load('cf.mat')
cf_p(cf_p==inf)=0;
cf_s(cf_s==inf)=0;
cf_t(cf_t==inf)=0;
countyno=unique(lonlat1(:,2));
primary_ssps_value_c1=zeros(length(lonlat1),81,5)*nan;
secondary_ssps_value_c1=zeros(length(lonlat1),81,5)*nan;
tertiary_ssps_value_c1=zeros(length(lonlat1),81,5)*nan;
for i=1:length(countyno)
    a=find(lonlat1(:,2)==countyno(i));
    primary_ssps_value_c1(a,:,:)=primary_ssps_value(a,:,:).*repmat(cf_p(i),length(a),81,5);
    secondary_ssps_value_c1(a,:,:)=secondary_ssps_value(a,:,:).*repmat(cf_s(i),length(a),81,5);
    tertiary_ssps_value_c1(a,:,:)=tertiary_ssps_value(a,:,:).*repmat(cf_t(i),length(a),81,5);
end
%calibration by provincal result
primary_ssps_value_c2=zeros(length(lonlat1),81,5)*nan;
secondary_ssps_value_c2=zeros(length(lonlat1),81,5)*nan;
tertiary_ssps_value_c2=zeros(length(lonlat1),81,5)*nan;
for i=1:length(provno)%31 province
    for s=1:5%5 ssps
        a=find(lonlat1(:,1)==provno(i));
        primary_ssps_value_c2(a,:,s)=primary_ssps_value_c1(a,:,s).*(repmat(allgdp1(11:end,i,s)'./sum(primary_ssps_value_c1(a,:,s),1),length(a),1,1));
        secondary_ssps_value_c2(a,:,s)=secondary_ssps_value_c1(a,:,s).*(repmat(allgdp2(11:end,i,s)'./sum(secondary_ssps_value_c1(a,:,s),1),length(a),1,1));
        tertiary_ssps_value_c2(a,:,s)=tertiary_ssps_value_c1(a,:,s).*(repmat(allgdp3(11:end,i,s)'./sum(tertiary_ssps_value_c1(a,:,s),1),length(a),1,1));
    end
end
save('value_ssps_c2','primary_ssps_value_c2','secondary_ssps_value_c2','tertiary_ssps_value_c2')



%%
%trend extrapolation
clear all
load('gridpara.mat')%grid raw data
lonlat1=gridpara(1:length(gridpara)/2,1:5);%centre of grid of historical period
load('historical_grid.mat')
load('value_ssps_c2')

luhlon=load('luhdata.mat','lon');luhlon=luhlon.lon;%load the centre of luh2 grids
luhlat=load('luhdata.mat','lat');luhlat=luhlat.lat;

primary_ssps_value_final=[];
secondary_ssps_value_final=[];
tertiary_ssps_value_final=[];
gcf_p=[];
gcf_s=[];
gcf_t=[];
for i=1:length(lonlat1)
    a=find(abs(luhlon-lonlat1(i,3))<0.0834);
    b=find(abs(luhlat-lonlat1(i,4))<0.0834);
    c=find((abs(luhlon(a)-lonlat1(:,3))<0.0834)&(abs(luhlat(b)-lonlat1(:,4))<0.0834));
    %primary industry
    change=primary15_final(c)-primary10_final(c);%grid change between 2010 and 2015
    d1=find(sign(change)==1);%Separate positive and negative changes
    if ~isempty(d1)
        gcf_p(c(d1),:)=(primary15_final(c(d1))-primary10_final(c(d1)))/(sum(primary15_final(c(d1))-primary10_final(c(d1))));%grid change factor
        primary_ssps_value_final(c(d1),:,:)=repmat(sum((primary_ssps_value_c2(c(d1),:,:)-repmat(primary15_final(c(d1)),1,81,5)),1),length(c(d1)),1,1).*repmat(gcf_p(c(d1),:),1,81,5)+repmat(primary15_final(c(d1)),1,81,5);
    end
    d2=find(sign(change)==-1);
    if ~isempty(d2)
        gcf_p(c(d2),:)=(primary15_final(c(d2))-primary10_final(c(d2)))/(sum(primary15_final(c(d2))-primary10_final(c(d2))));%grid change factor
        primary_ssps_value_final(c(d2),:,:)=repmat(sum((primary_ssps_value_c2(c(d2),:,:)-repmat(primary15_final(c(d2)),1,81,5)),1),length(c(d2)),1,1).*repmat(gcf_p(c(d2),:),1,81,5)+repmat(primary15_final(c(d2)),1,81,5);
    end
    d3=find(sign(change)==0);
    if ~isempty(d3)
        gcf_p(c(d3),:)=repmat(1/length(d3),length(d3),1);%grid change factor
        primary_ssps_value_final(c(d3),:,:)=repmat(sum((primary_ssps_value_c2(c(d3),:,:)-repmat(primary15_final(c(d3)),1,81,5)),1),length(c(d3)),1,1).*repmat(gcf_p(c(d3),:),1,81,5)+repmat(primary15_final(c(d3)),1,81,5);
    end
    %secondary industry
    change=secondary15_final(c)-secondary10_final(c);%grid change between 2010 and 2015
    d1=find(sign(change)==1);%Separate positive and negative changes
    if ~isempty(d1)
        gcf_s(c(d1),:)=(secondary15_final(c(d1))-secondary10_final(c(d1)))/(sum(secondary15_final(c(d1))-secondary10_final(c(d1))));%grid change factor
        secondary_ssps_value_final(c(d1),:,:)=repmat(sum((secondary_ssps_value_c2(c(d1),:,:)-repmat(secondary15_final(c(d1)),1,81,5)),1),length(c(d1)),1,1).*repmat(gcf_s(c(d1),:),1,81,5)+repmat(secondary15_final(c(d1)),1,81,5);
    end
    d2=find(sign(change)==-1);
    if ~isempty(d2)
        gcf_s(c(d2),:)=(secondary15_final(c(d2))-secondary10_final(c(d2)))/(sum(secondary15_final(c(d2))-secondary10_final(c(d2))));%grid change factor
        secondary_ssps_value_final(c(d2),:,:)=repmat(sum((secondary_ssps_value_c2(c(d2),:,:)-repmat(secondary15_final(c(d2)),1,81,5)),1),length(c(d2)),1,1).*repmat(gcf_s(c(d2),:),1,81,5)+repmat(secondary15_final(c(d2)),1,81,5);
    end
    d3=find(sign(change)==0);
    if ~isempty(d3)
        gcf_s(c(d3),:)=repmat(1/length(d3),length(d3),1);%grid change factor
        secondary_ssps_value_final(c(d3),:,:)=repmat(sum((secondary_ssps_value_c2(c(d3),:,:)-repmat(secondary15_final(c(d3)),1,81,5)),1),length(c(d3)),1,1).*repmat(gcf_s(c(d3),:),1,81,5)+repmat(secondary15_final(c(d3)),1,81,5);
    end
    %tertiary industry
    change=tertiary15_final(c)-tertiary10_final(c);%grid change between 2010 and 2015
    d1=find(sign(change)==1);%Separate positive and negative changes
    if ~isempty(d1)
        gcf_t(c(d1),:)=(tertiary15_final(c(d1))-tertiary10_final(c(d1)))/(sum(tertiary15_final(c(d1))-tertiary10_final(c(d1))));%grid change factor
        tertiary_ssps_value_final(c(d1),:,:)=repmat(sum((tertiary_ssps_value_c2(c(d1),:,:)-repmat(tertiary15_final(c(d1)),1,81,5)),1),length(c(d1)),1,1).*repmat(gcf_t(c(d1),:),1,81,5)+repmat(tertiary15_final(c(d1)),1,81,5);
    end
    d2=find(sign(change)==-1);
    if ~isempty(d2)
        gcf_t(c(d2),:)=(tertiary15_final(c(d2))-tertiary10_final(c(d2)))/(sum(tertiary15_final(c(d2))-tertiary10_final(c(d2))));%grid change factor
        tertiary_ssps_value_final(c(d2),:,:)=repmat(sum((tertiary_ssps_value_c2(c(d2),:,:)-repmat(tertiary15_final(c(d2)),1,81,5)),1),length(c(d2)),1,1).*repmat(gcf_t(c(d2),:),1,81,5)+repmat(tertiary15_final(c(d2)),1,81,5);
    end
    d3=find(sign(change)==0);
    if ~isempty(d3)
        gcf_t(c(d3),:)=repmat(1/length(d3),length(d3),1);%grid change factor
        tertiary_ssps_value_final(c(d3),:,:)=repmat(sum((tertiary_ssps_value_c2(c(d3),:,:)-repmat(tertiary15_final(c(d3)),1,81,5)),1),length(c(d3)),1,1).*repmat(gcf_t(c(d3),:),1,81,5)+repmat(tertiary15_final(c(d3)),1,81,5);
    end    
end

primary_ssps_value_final(primary_ssps_value_final<0)=0;
secondary_ssps_value_final(secondary_ssps_value_final<0)=0;
tertiary_ssps_value_final(tertiary_ssps_value_final<0)=0;

%%
%save final results
save('value_added_ssps_final.mat','primary_ssps_value_final','secondary_ssps_value_final','tertiary_ssps_value_final')



