%based on the estimate resylt of gam, 
%calculate the value-added in 2010 and2015

clear all
clc
cd('E:\code')%set working directory
%load the data
load('pred_grid.mat')%estimated grid results of GAM
load('gridpara.mat')%grid raw data
load('provsumgrid.mat')%provincial value where grid located 
load('fitdata')%county raw data
load('provsum')%provincial value where county located 

%Keep all grids positive
pred_primary(pred_primary<0)=0;
pred_primary(isnan(pred_primary))=0;%percent of the value in province
pred_secondary(pred_secondary<0)=0;
pred_secondary(isnan(pred_secondary))=0;%percent of the value in province
pred_tertiary(pred_tertiary<0)=0;
pred_tertiary(isnan(pred_tertiary))=0;%percent of the value in province

grid10=gridpara(1:length(gridpara)/2,:);
grid15=gridpara(length(gridpara)/2+1:end,:);
county10=fitdata(1:length(fitdata)/2,:);
county15=fitdata(length(fitdata)/2+1:end,:);
primary10=pred_primary(1:length(pred_primary)/2);
primary15=pred_primary(length(pred_primary)/2+1:end);
secondary10=pred_secondary(1:length(pred_secondary)/2);
secondary15=pred_secondary(length(pred_secondary)/2+1:end);
tertiary10=pred_tertiary(1:length(pred_tertiary)/2);
tertiary15=pred_tertiary(length(pred_tertiary)/2+1:end);


%calibration for grid estimation
%calculate value-added, million yuan
provno=unique(grid10(:,1));
for i=1:length(provno)
    a=find(grid10(:,1)==provno(i));
    b=find(county10(:,1)==provno(i));
    primary10_value(a,:)=repmat(sum(county10(b,5)),length(a),1).*primary10(a)/100/100;%million yuan
    primary15_value(a,:)=repmat(sum(county15(b,5)),length(a),1).*primary15(a)/100/100;
    secondary10_value(a,:)=repmat(sum(county10(b,6)),length(a),1).*secondary10(a)/100/100;%million yuan
    secondary15_value(a,:)=repmat(sum(county15(b,6)),length(a),1).*secondary15(a)/100/100;
    tertiary10_value(a,:)=repmat(sum(county10(b,7)),length(a),1).*tertiary10(a)/100/100;%million yuan
    tertiary15_value(a,:)=repmat(sum(county15(b,7)),length(a),1).*tertiary15(a)/100/100;    
end

%calibration by countylevel data
provno=unique(grid10(:,1));
countyno=unique(grid10(:,2));
for i=1:length(countyno)
    a=find(grid10(:,2)==countyno(i));
    b=find(county10(:,2)==countyno(i));
    primary10_final(a,:)=primary10_value(a)/sum(primary10_value(a))*county10(b,5)/100;%million yuan
    primary15_final(a,:)=primary15_value(a)/sum(primary15_value(a))*county15(b,5)/100;
    cf_p(i)=(county10(b,5)+county15(b,5))/(sum(primary10_value(a))+sum(primary15_value(a)))/100;%calibration factor
    secondary10_final(a,:)=secondary10_value(a)/sum(secondary10_value(a))*county10(b,6)/100;
    secondary15_final(a,:)=secondary15_value(a)/sum(secondary15_value(a))*county15(b,6)/100;
    cf_s(i)=(county10(b,6)+county15(b,6))/(sum(secondary10_value(a))+sum(secondary15_value(a)))/100;%calibration factor
    tertiary10_final(a,:)=tertiary10_value(a)/sum(tertiary10_value(a))*county10(b,7)/100;
    tertiary15_final(a,:)=tertiary15_value(a)/sum(tertiary15_value(a))*county15(b,7)/100;
    cf_t(i)=(county10(b,7)+county15(b,7))/(sum(tertiary10_value(a))+sum(tertiary15_value(a)))/100;%calibration factor
end
%set nodata to 0
primary10_final(isnan(primary10_final))=0;
primary15_final(isnan(primary15_final))=0;
secondary10_final(isnan(secondary10_final))=0;
secondary15_final(isnan(secondary15_final))=0;
tertiary10_final(isnan(tertiary10_final))=0;
tertiary15_final(isnan(tertiary15_final))=0;

save('cf','cf_p','cf_s','cf_t')
save('historical_grid','primary10_final','primary15_final','secondary10_final','secondary15_final','tertiary10_final','tertiary15_final')

