#build the downscaling model and calculate the grid value-added

rm(list=ls())
library(mgcv)
library(rJava)
library(R.matlab)

setwd('E:/code') ##set working directory
fitdata=readMat('fitdata.mat')
provsum=readMat('provsum.mat')
fitdata=fitdata$fitdata#import data 
provsum=provsum$provsum

##########################################################################################
##build model
my.gam <- function(formula, data, family=poisson, k=5, method="GCV.Cp") {
  response.name <- as.character(formula)[2]
  predictor.names <- labels(terms(formula))
  categorical <- sapply(data[,predictor.names], is.logical) |
    sapply(data[,predictor.names], is.factor)
  formula <- paste(response.name, "~",
                   paste(predictor.names[categorical], collapse = "+"),
                   paste("s(", predictor.names[!categorical], ", k=", k, ")", collapse = "+"))
  formula <- as.formula(formula)
  fit <- gam(formula, data, family = family,method=method)
  return(fit)
}


#model1
value_primary=ceiling(fitdata[,5]*10)#thousand yuan
value_secondary=ceiling(fitdata[,6]*10)
value_tertiary=ceiling(fitdata[,7]*10)

urban=fitdata[,9]#km2
cropland=fitdata[,10]
pasture=fitdata[,11]
rangeland=fitdata[,12]
otherland=fitdata[,13]

fml1p<-value_primary~urban+cropland+pasture+rangeland+otherland
data1p=data.frame(value_primary,urban,cropland,pasture,rangeland,otherland)
model1p <- my.gam(fml1p, data1p)
summary(model1p)

fml1s<-value_secondary~urban+cropland+pasture+rangeland+otherland
data1s=data.frame(value_secondary,urban,cropland,pasture,rangeland,otherland)
model1s <- my.gam(fml1s, data1s)
summary(model1s)

fml1t<-value_tertiary~urban+cropland+pasture+rangeland+otherland
data1t=data.frame(value_tertiary,urban,cropland,pasture,rangeland,otherland)
model1t <- my.gam(fml1t, data1t)
summary(model1t)

#model2
value_pr_primary=ceiling(fitdata[,5]/fitdata[,8]*10)#thousand yuan per km2
value_pr_secondary=ceiling(fitdata[,6]/fitdata[,8]*10)
value_pr_tertiary=ceiling(fitdata[,7]/fitdata[,8]*10)

urban_pr=fitdata[,9]/fitdata[,8]*100#percent
cropland_pr=fitdata[,10]/fitdata[,8]*100
pasture_pr=fitdata[,11]/fitdata[,8]*100
rangeland_pr=fitdata[,12]/fitdata[,8]*100
otherland_pr=fitdata[,13]/fitdata[,8]*100

fml2p<-value_pr_primary~urban_pr+cropland_pr+pasture_pr+rangeland_pr+otherland_pr
data2p=data.frame(value_pr_primary,urban_pr,cropland_pr,pasture_pr,rangeland_pr,otherland_pr)
model2p <- my.gam(fml2p, data2p)
summary(model2p)

fml2s<-value_pr_secondary~urban_pr+cropland_pr+pasture_pr+rangeland_pr+otherland_pr
data2s=data.frame(value_pr_secondary,urban_pr,cropland_pr,pasture_pr,rangeland_pr,otherland_pr)
model2s <- my.gam(fml2s, data2s)
summary(model2s)

fml2t<-value_pr_tertiary~urban_pr+cropland_pr+pasture_pr+rangeland_pr+otherland_pr
data2t=data.frame(value_pr_tertiary,urban_pr,cropland_pr,pasture_pr,rangeland_pr,otherland_pr)
model2t <- my.gam(fml2t, data2t)
summary(model2t)


#model3
value_pp_primary=ceiling(fitdata[,5]/provsum[,1]*100)# percent
value_pp_secondary=ceiling(fitdata[,6]/provsum[,2]*100)
value_pp_tertiary=ceiling(fitdata[,7]/provsum[,3]*100)

urban_pp=fitdata[,9]/(provsum[,5]+0.1)*100# percent
cropland_pp=fitdata[,10]/(provsum[,6]+0.1)*100
pasture_pp=fitdata[,11]/(provsum[,7]+0.1)*100
rangeland_pp=fitdata[,12]/(provsum[,8]+0.1)*100
otherland_pp=fitdata[,13]/(provsum[,9]+0.1)*100


fml3p<-value_pp_primary~urban_pp+cropland_pp+pasture_pp+rangeland_pp+otherland_pp
data3p=data.frame(value_pp_primary,urban_pp,cropland_pp,pasture_pp,rangeland_pp,otherland_pp)
model3p <- my.gam(fml3p, data3p)
summary(model3p)

fml3s<-value_pp_secondary~urban_pp+cropland_pp+pasture_pp+rangeland_pp+otherland_pp
data3s=data.frame(value_pp_primary,urban_pp,cropland_pp,pasture_pp,rangeland_pp,otherland_pp)
model3s <- my.gam(fml3s, data3s)
summary(model3s)

fml3t<-value_pp_tertiary~urban_pp+cropland_pp+pasture_pp+rangeland_pp+otherland_pp
data3t=data.frame(value_pp_primary,urban_pp,cropland_pp,pasture_pp,rangeland_pp,otherland_pp)
model3t <- my.gam(fml3t, data3t)
summary(model3t)


#based on the r-sq. and deviance explained, choose model3 for primary, secondary and tertiary industries

#then estimate###########################################################################################
#historical

gridpara=readMat('gridpara.mat')
provsumgrid=readMat('provsumgrid.mat')
gridpara=gridpara$gridpara#import data 
provsumgrid=provsumgrid$provsumgrid

urban_pp=gridpara[,6]/(provsumgrid[,2]+0.1)*100# percent , 
cropland_pp=gridpara[,7]/(provsumgrid[,3]+0.1)*100
pasture_pp=gridpara[,8]/(provsumgrid[,4]+0.1)*100
rangeland_pp=gridpara[,9]/(provsumgrid[,5]+0.1)*100
otherland_pp=gridpara[,10]/(provsumgrid[,6]+0.1)*00

data3=data.frame(urban_pp,cropland_pp,pasture_pp,rangeland_pp,otherland_pp)
pred_primary=exp(predict.gam(model3p,data3))#poisson with log link
pred_secondary=exp(predict.gam(model3s,data3))#poisson with log link
pred_tertiary=exp(predict.gam(model3t,data3))#poisson with log link


writeMat('pred_grid.mat',pred_primary=pred_primary,pred_secondary=pred_secondary,pred_tertiary=pred_tertiary)



#estimate for future value-added under ssps

for (i in 1:5){
  landuse_ssps=readMat(paste0('landuse_ssp',i,'_pp.mat'),fixNames,'FALSE')#load data
  urban=landuse_ssps$urban_ssp_pp
  cropland=landuse_ssps$cropland_ssp_pp
  pasture=landuse_ssps$pasture_ssp_pp
  rangeland=landuse_ssps$rangeland_ssp_pp
  otherland=landuse_ssps$otherland_ssp_pp
  d=attributes(urban)
  
  pred_primary=vector(length=0)
  pred_secondary=vector(length=0)
  pred_tertiary=vector(length=0)
  for (j in 1:d$dim[2]){ #calculate for each year
    urban_pp=urban[,j]
    cropland_pp=cropland[,j]
    pasture_pp=pasture[,j]
    rangeland_pp=rangeland[,j]
    otherland_pp=otherland[,j]
    
    data3=data.frame(urban_pp,cropland_pp,pasture_pp,rangeland_pp,otherland_pp)
    pred_primary=cbind(pred_primary,exp(predict.gam(model3p,data3)))
    pred_secondary=cbind(pred_secondary,exp(predict.gam(model3s,data3)))
    pred_tertiary=cbind(pred_tertiary,exp(predict.gam(model3t,data3)))
  }

  writeMat(paste0('pred_grid_ssp',i,'.mat'),pred_primary=pred_primary,pred_secondary=pred_secondary,pred_tertiary=pred_tertiary)
  rm(landuse_ssps,urban,cropland,pasture,rangeland,otherland,pred_primary,pred_secondary,pred_tertiary)
}
    
    
    




