%future landuse under ssps which import to GAM model in R
clear all
clc
cd('E:\code')%set working directory
load('luhdata.mat')
load('gridpara.mat')%grid raw data
lonlat1=gridpara(1:length(gridpara)/2,1:5);%centre of grid of historical period

landtype={'urban' 'cropland' 'pastr' 'range' 'otherland'};
landtype1={'urban' 'cropland' 'pasture' 'rangeland' 'otherland'};

%calculate gird data for future
%To keep the scale consistent, we first assign future landuse of 0.25 degree to each 0.0833 degree grid
for j=1:5%5 ssps
    for t=1:length(landtype1)%5 types of landuse
        tic
        for i=1:length(lonlat1)
            a=find(abs(lon-lonlat1(i,3))<0.0834);%the 0.0833 degree grid coverd by 0.25 degree grid
            b=find(abs(lat-lonlat1(i,4))<0.0834);
            eval([landtype1{t} '_ssps(i,:,j)=' landtype{t} '_p' num2str(j) '(a,b,:);'])
        end
        toc
    end
end
urban_ssps(isnan(urban_ssps))=0;
cropland_ssps(isnan(cropland_ssps))=0;
pasture_ssps(isnan(pasture_ssps))=0;
rangeland_ssps(isnan(rangeland_ssps))=0;
otherland_ssps(isnan(otherland_ssps))=1;%nan in luh2 is water
save('future_landuse.mat','urban_ssps','cropland_ssps','pasture_ssps','rangeland_ssps','otherland_ssps')


%area of each type and the ratio to the total value of the province
provno=unique(gridpara(:,1));
for i=1:length(provno)
    for t=1:length(landtype1)
        eval([landtype1{t} '_area=' landtype1{t} '_ssps.*repmat(lonlat1(:,5),1,86,5);'])%the area of each type
        a=find(lonlat1(:,1)==provno(i));
        eval([landtype1{t} '_ssps_pp(a,:,:)=' landtype1{t} '_area(a,:,:)./repmat(sum(' landtype1{t} '_area(a,:,:),1),length(a),1,1)*100;'])
    end
end
save('future_landuse_pp.mat','urban_ssps_pp','cropland_ssps_pp','pasture_ssps_pp','rangeland_ssps_pp','otherland_ssps_pp')

%save the result separately,because there is size limit in R
for i=1:5
    urban_ssp_pp=urban_ssps_pp(:,:,i);
    cropland_ssp_pp=cropland_ssps_pp(:,:,i);
    pasture_ssp_pp=pasture_ssps_pp(:,:,i);
    rangeland_ssp_pp=rangeland_ssps_pp(:,:,i);
    otherland_ssp_pp=otherland_ssps_pp(:,:,i);
    save(['landuse_ssp' num2str(i) '_pp.mat'],'urban_ssp_pp','cropland_ssp_pp','pasture_ssp_pp','rangeland_ssp_pp','otherland_ssp_pp')
end
    
