%load the historical landuse data and county-level data
%calculate the parameters which import in downscaling model

clear all
clc
cd('E:\code')%set working directory
%%HYDE3.2 Coordinate and area of grid
lon=-180+1/24:1/12:180;%centre of grid
lat=-90+1/24:1/12:90;%centre of grid
[Lon,Lat]=meshgrid(lon,-lat);area=(111*360/4320)^2*cos(Lat/180*pi);

%%load HYDE3.2 data
%year 2010
urban2010=dlmread('uopp_2010AD.asc','%t',6,0);
urban2010(urban2010==-9999.0)=nan;
cropland2010=dlmread('cropland2010AD.asc','%t',6,0);
cropland2010(cropland2010==-9999.0)=nan;
pasture2010=dlmread('pasture2010AD.asc','%t',6,0);
pasture2010(pasture2010==-9999.0)=nan;
rangeland2010=dlmread('rangeland2010AD.asc','%t',6,0);
rangeland2010(rangeland2010==-9999.0)=nan;
other2010=area-urban2010-cropland2010-pasture2010-rangeland2010;
other2010(other2010<0)=0;
%year 2015
urban2015=dlmread('uopp_2015AD.asc','%t',6,0);
urban2015(urban2015==-9999.0)=nan;
cropland2015=dlmread('cropland2015AD.asc','%t',6,0);
cropland2015(cropland2015==-9999.0)=nan;
pasture2015=dlmread('pasture2015AD.asc','%t',6,0);
pasture2015(pasture2015==-9999.0)=nan;
rangeland2015=dlmread('rangeland2015AD.asc','%t',6,0);
rangeland2015(rangeland2015==-9999.0)=nan;
other2015=area-urban2015-cropland2015-pasture2015-rangeland2015;
other2015(other2015<0)=0;
[x,y]=size(urban2010);%size of grid data

%County boundary and county level data
county=shaperead('countylevel_data.shp');
chinaarea=zeros(x,y)*nan;

%the parameter for model fitting
fitpara10=[];%countylevel data
fitpara15=[];
gridpara10=[];%grid data
gridpara15=[];

nodata=[];%record of too small county
for i=1:length(county)
    scale=inpolygon(Lon,Lat,county(i).X,county(i).Y);
    [xx,yy]=find(scale==1);
    if (length(xx)==0)
        nodata=[nodata;i];
        continue
    end
    chinaarea((scale==1))=1;%record of all the grid in china
    county1=[];%character of all the gird in the county
    for j=1:length(xx)
        county1(j,:)=[Lon(xx(j),yy(j)) Lat(xx(j),yy(j)) area(xx(j),yy(j)) urban2010(xx(j),yy(j)) urban2015(xx(j),yy(j)) ...
            cropland2010(xx(j),yy(j)) cropland2015(xx(j),yy(j)) pasture2010(xx(j),yy(j)) pasture2015(xx(j),yy(j))...
            rangeland2010(xx(j),yy(j)) rangeland2015(xx(j),yy(j)) other2010(xx(j),yy(j)) other2015(xx(j),yy(j))];
    end
    [m,n]=size(county1);
    grid10=[repmat([county(i).FID_provin i],m,1) county1(:,[1;2;3;4;6;8;10;12])];
    grid15=[repmat([county(i).FID_provin i],m,1) county1(:,[1;2;3;5;7;9;11;13])];
    
    gridpara10=[gridpara10;grid10];
    gridpara15=[gridpara15;grid15];
    %1.province_No,2.county_No,3.lon,4.lat,5.area,6.urban,7.cropland,8.pasture,9.rangeland,10.otherland    

    fitpara10(i,:)=[county(i).FID_provin i county(i).lon county(i).lat county(i).primary10 county(i).scondary10 ...
        county(i).tertiary10 nansum(county1(:,[3;4;6;8;10;12]),1)];
    fitpara15(i,:)=[county(i).FID_provin i county(i).lon county(i).lat county(i).primary15 county(i).scondary15 ...
        county(i).tertiary15 nansum(county1(:,[3;5;7;9;11;13]),1)];
    %1.province_No,2.county_No,3.lon,4.lat,5.primary,6.secondary,7.tertiary,8.area,9.urban,10.cropland,11.pasture,12.rangeland,13.otherland    
end

fitpara10(nodata,:)=[];%Remove counties without data
fitpara15(nodata,:)=[];

provsum10=[];%the sum value of the province where county located
provsum15=[];
provsumgrid10=[];%the sum value of the province where grid located
provsumgrid15=[];

for i=0:30
    a=find(fitpara10(:,1)==i);
    b=find(gridpara10(:,1)==i);
    provsum10(a,:)=repmat(sum(fitpara10(a,5:end)),length(a),1);
    provsum15(a,:)=repmat(sum(fitpara15(a,5:end)),length(a),1);
    provsumgrid10(b,:)=repmat(nansum(gridpara10(b,5:end)),length(b),1);
    provsumgrid15(b,:)=repmat(nansum(gridpara15(b,5:end)),length(b),1);
end

fitdata=[fitpara10;fitpara15];%countylevel samples
provsum=[provsum10;provsum15];%the sum value of the province where county located
%1.primary,2.secondary,3.tertiary,4.area,5.urban,6.cropland,7.pasture,8.rangeland,9.otherland  
save('fitdata.mat','fitdata')
save('provsum.mat','provsum')       

gridpara=[gridpara10;gridpara15];%grid data
provsumgrid=[provsumgrid10;provsumgrid15];%the sum value of the province where grid located
%1.area,2.urban,3.cropland,4.pasture,5.rangeland,6.otherland  
save('gridpara.mat','gridpara')
save('provsumgrid.mat','provsumgrid') 
        

%%the data are import to gam model in R

