function plot_yaw_turbine(case_ids, controller_ids, cases, iT, dir)
dir = interp1(dir(:,1), dir(:,2), cases.t);

for iC = 1:length(case_ids)
    figure
    hold on
    for iiC = 1:length(controller_ids)
        plot3(dir' - cases.yaw_ori{case_ids(iC),controller_ids(iiC)}(:,iT),...
            cases.yaw_ori{case_ids(iC),controller_ids(iiC)}(:,iT), ...
            cases.t, 'LineWidth',1, ...
            'Color',cases.colors(controller_ids(iiC),:), ...
            'LineStyle',cases.line{controller_ids(iiC)})
    end
    grid on
    legend(cases.names(controller_ids),'Location','best')
    %plot(dir(:,2), dir(:,1), ':k', 'LineWidth', 2)
    zlabel('Time [h]')
    ylabel('Orientation [deg]')
    xlabel('Misalignment angle [deg]')
    title([cases.case_names{case_ids(iC)}, ' T' num2str(iT-1)])
    zlim([cases.t(1), cases.t(end)])
end
end