function plot_window_yaw_travel(case_ids, controller_ids, cases, time_window)
for iC = 1:length(case_ids)
    figure
    hold on
    for iiC = 1:length(controller_ids)
        plot(cases.t(1:size(cases.yaw_travel_window{case_ids(iC), controller_ids(iiC)},1)), ...
            sum(cases.yaw_travel_window{case_ids(iC), controller_ids(iiC)},2), ...
            'LineWidth',2, ...
            'Color',cases.colors(controller_ids(iiC),:), ...
            'LineStyle',cases.line{controller_ids(iiC)})
    end
    grid on
    legend(cases.names(controller_ids),'Location','best')
    xlabel('Time in h')
    ylabel(['Yaw travel over ' num2str(time_window) ' s in deg'])
    title(cases.case_names{case_ids(iC)})
    xlim([cases.t(1), cases.t(end)])
end
end