function plot_turbine_window_energy_combined(case_ids, controller_ids_tmp, cases, iT, time_window)
for iC = 1:length(case_ids)
    figure
    hold on
    for iiC = 1:length(controller_ids_tmp)
        energy_cumu = zeros(size(cases.energy_window{case_ids(iC), controller_ids_tmp(iiC)}(:,iT(1))));

        for iiT = 1:length(iT)
            energy_cumu = energy_cumu + ...
                cases.energy_window{case_ids(iC), controller_ids_tmp(iiC)}(:,iT(iiT));
        end
        % for iT = 1:10
            plot(cases.t(1:length(energy_cumu)), ...
                energy_cumu, ...
                'LineWidth',2, ...
                'Color',cases.colors(controller_ids_tmp(iiC),:), ...
                'LineStyle',cases.line{controller_ids_tmp(iiC)})


        % end
    end
    grid on
    legend(cases.names(controller_ids_tmp),'Location','best')
    xlabel(['Time in h'])
    ylabel(['Energy over ' num2str(time_window) ' s in MWh'])
    title([cases.case_names{case_ids(iC)}, ', Turbines ' num2str(iT-1)])
    %xlim([cases.t(1), cases.t(end)])
end
end