function plot_turbine_window_energy(case_ids, controller_ids_tmp, cases, iT, time_window)
for iC = 1:length(case_ids)
    figure
    hold on
    for iiC = 1:length(controller_ids_tmp)
        % for iT = 1:10
            plot(cases.t(1:size(cases.energy_window{case_ids(iC), controller_ids_tmp(iiC)},1)), ...
                cases.energy_window{case_ids(iC), controller_ids_tmp(iiC)}(:,iT), ...
                'LineWidth',2, ...
                'Color',cases.colors(controller_ids_tmp(iiC),:), ...
                'LineStyle',cases.line{controller_ids_tmp(iiC)})


        % end
    end
    grid on
    legend(cases.names(controller_ids_tmp),'Location','best')
    xlabel(['Time in h'])
    ylabel(['Norm. Energy over ' num2str(time_window) ' s in MWh/MWh'])
    title([cases.case_names{case_ids(iC)}, ', T' num2str(iT-1)])
    %xlim([cases.t(1), cases.t(end)])
end
end