function plot_turbine_norm_window_energy_combined(case_ids, controller_ids_tmp, cases, iT, time_window, norm_id)
for iC = 1:length(case_ids)
    figure
    hold on
    
    % Get norm data
    energy_cumu_norm = zeros(size(cases.energy_window{case_ids(iC), controller_ids_tmp(norm_id)}(:,iT(1))));

    for iiT = 1:length(iT)
        energy_cumu_norm = energy_cumu_norm + ...
            cases.energy_window{case_ids(iC), controller_ids_tmp(norm_id)}(:,iT(iiT));
    end


    for iiC = 1:length(controller_ids_tmp)
        energy_cumu = zeros(size(cases.energy_window{case_ids(iC), controller_ids_tmp(iiC)}(:,iT(1))));

        for iiT = 1:length(iT)
            energy_cumu = energy_cumu + ...
                cases.energy_window{case_ids(iC), controller_ids_tmp(iiC)}(:,iT(iiT));
        end
        % for iT = 1:10
            plot(cases.t(1:length(energy_cumu)), ...
                energy_cumu./energy_cumu_norm, ...
                'LineWidth',2, ...
                'Color',cases.colors(controller_ids_tmp(iiC),:), ...
                'LineStyle',cases.line{controller_ids_tmp(iiC)})


        % end
    end
    grid on
    legend(cases.names(controller_ids_tmp),'Location','best')
    xlabel(['Time in h'])
    ylabel(['Norm. Energy over ' num2str(time_window) ' s in MWh/MWh'])
    title([cases.case_names{case_ids(iC)}, ', Turbines ' num2str(iT-1)])
    %xlim([cases.t(1), cases.t(end)])
end
end