function plot_turbine_norm_power(case_ids, controller_ids_tmp, cases, iT, norm_id)
for iC = 1:length(case_ids)
    figure
    hold on
    for iiC = 1:length(controller_ids_tmp)
        % for iT = 1:10
            plot(cases.t, ...
                cases.power{case_ids(iC), controller_ids_tmp(iiC)}(:,iT) ./ cases.power{case_ids(iC), controller_ids_tmp(norm_id)}(:,iT), ...
                'LineWidth',2, ...
                'Color',cases.colors(controller_ids_tmp(iiC),:), ...
                'LineStyle',cases.line{controller_ids_tmp(iiC)})


        % end
    end
    grid on
    legend(cases.names(controller_ids_tmp),'Location','best')
    xlabel(['Time in h'])
    ylabel(['Norm. Power in MW/MW'])
    title([cases.case_names{case_ids(iC)}, ', T' num2str(iT-1)])
end
end