function plot_turbine_diff_window_energy(case_ids, controller_ids_tmp, cases, iT, norm_id, time_window)
for iC = 1:length(case_ids)
    figure
    hold on
    for iiC = 1:length(controller_ids_tmp)
        % for iT = 1:10
            plot(cases.t(1:size(cases.energy_window{case_ids(iC), controller_ids_tmp(iiC)},1)), ...
                cases.energy_window{case_ids(iC), controller_ids_tmp(iiC)}(:,iT) - ...
                cases.energy_window{case_ids(iC), controller_ids_tmp(norm_id)}(:,iT), ...
                'LineWidth',2, ...
                'Color',cases.colors(controller_ids_tmp(iiC),:), ...
                'LineStyle',cases.line{controller_ids_tmp(iiC)})


        % end
    end
    grid on
    legend(cases.names(controller_ids_tmp),'Location','best')
    xlabel(['Time in h'])
    ylabel(['Difference in Energy over ' num2str(time_window) ' s in MWh'])
    title([cases.case_names{case_ids(iC)}, ', T' num2str(iT-1)])
end
end