function plot_ori_turbine(case_ids, controller_ids, cases, iT, dir)
for iC = 1:length(case_ids)
    figure
    hold on
    for iiC = 1:length(controller_ids)
        plot(cases.yaw_ori{case_ids(iC), controller_ids(iiC)}(:,iT),...
            cases.t, 'LineWidth',1, ...
            'Color',cases.colors(controller_ids(iiC),:), ...
            'LineStyle',cases.line{controller_ids(iiC)})
    end
    grid on
    legend(cases.names(controller_ids),'Location','best')
    plot(dir(:,2), dir(:,1), ':k', 'LineWidth', 2)
    ylabel('Time in h')
    xlabel('Orientation (domain) [deg]')
    title([cases.case_names{case_ids(iC)}, ' T' num2str(iT-1)])
    ylim([cases.t(1), cases.t(end)])
end
end